/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.BuildOutput;
import io.fabric8.openshift.api.model.BuildOutputFluent;
import io.fabric8.openshift.api.model.BuildOutputFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class BuildOutputBuilder
extends BuildOutputFluentImpl<BuildOutputBuilder>
implements VisitableBuilder<BuildOutput, BuildOutputBuilder> {
    BuildOutputFluent<?> fluent;

    public BuildOutputBuilder() {
        this(new BuildOutput());
    }

    public BuildOutputBuilder(BuildOutputFluent<?> fluent) {
        this(fluent, new BuildOutput());
    }

    public BuildOutputBuilder(BuildOutputFluent<?> fluent, BuildOutput instance) {
        this.fluent = fluent;
        fluent.withPushSecret(instance.getPushSecret());
        fluent.withTo(instance.getTo());
    }

    public BuildOutputBuilder(BuildOutput instance) {
        this.fluent = this;
        this.withPushSecret(instance.getPushSecret());
        this.withTo(instance.getTo());
    }

    public BuildOutput build() {
        BuildOutput buildable = new BuildOutput(this.fluent.getPushSecret(), this.fluent.getTo());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildOutputBuilder that = (BuildOutputBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

