/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressRuleValue;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressRuleValueFluent;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressRuleValueFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class HTTPIngressRuleValueBuilder
extends HTTPIngressRuleValueFluentImpl<HTTPIngressRuleValueBuilder>
implements VisitableBuilder<HTTPIngressRuleValue, HTTPIngressRuleValueBuilder> {
    HTTPIngressRuleValueFluent<?> fluent;

    public HTTPIngressRuleValueBuilder() {
        this(new HTTPIngressRuleValue());
    }

    public HTTPIngressRuleValueBuilder(HTTPIngressRuleValueFluent<?> fluent) {
        this(fluent, new HTTPIngressRuleValue());
    }

    public HTTPIngressRuleValueBuilder(HTTPIngressRuleValueFluent<?> fluent, HTTPIngressRuleValue instance) {
        this.fluent = fluent;
        fluent.withPaths(instance.getPaths());
    }

    public HTTPIngressRuleValueBuilder(HTTPIngressRuleValue instance) {
        this.fluent = this;
        this.withPaths(instance.getPaths());
    }

    public HTTPIngressRuleValue build() {
        HTTPIngressRuleValue buildable = new HTTPIngressRuleValue(this.fluent.getPaths());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HTTPIngressRuleValueBuilder that = (HTTPIngressRuleValueBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

