/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.KeyToPath;
import io.fabric8.kubernetes.api.model.KeyToPathFluent;
import io.fabric8.kubernetes.api.model.KeyToPathFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class KeyToPathBuilder
extends KeyToPathFluentImpl<KeyToPathBuilder>
implements VisitableBuilder<KeyToPath, KeyToPathBuilder> {
    KeyToPathFluent<?> fluent;

    public KeyToPathBuilder() {
        this(new KeyToPath());
    }

    public KeyToPathBuilder(KeyToPathFluent<?> fluent) {
        this(fluent, new KeyToPath());
    }

    public KeyToPathBuilder(KeyToPathFluent<?> fluent, KeyToPath instance) {
        this.fluent = fluent;
        fluent.withKey(instance.getKey());
        fluent.withPath(instance.getPath());
    }

    public KeyToPathBuilder(KeyToPath instance) {
        this.fluent = this;
        this.withKey(instance.getKey());
        this.withPath(instance.getPath());
    }

    public KeyToPath build() {
        KeyToPath buildable = new KeyToPath(this.fluent.getKey(), this.fluent.getPath());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KeyToPathBuilder that = (KeyToPathBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

