/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.DaemonEndpoint;
import io.fabric8.kubernetes.api.model.DaemonEndpointFluent;
import io.fabric8.kubernetes.api.model.DaemonEndpointFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class DaemonEndpointBuilder
extends DaemonEndpointFluentImpl<DaemonEndpointBuilder>
implements VisitableBuilder<DaemonEndpoint, DaemonEndpointBuilder> {
    DaemonEndpointFluent<?> fluent;

    public DaemonEndpointBuilder() {
        this(new DaemonEndpoint());
    }

    public DaemonEndpointBuilder(DaemonEndpointFluent<?> fluent) {
        this(fluent, new DaemonEndpoint());
    }

    public DaemonEndpointBuilder(DaemonEndpointFluent<?> fluent, DaemonEndpoint instance) {
        this.fluent = fluent;
        fluent.withPort(instance.getPort());
    }

    public DaemonEndpointBuilder(DaemonEndpoint instance) {
        this.fluent = this;
        this.withPort(instance.getPort());
    }

    public DaemonEndpoint build() {
        DaemonEndpoint buildable = new DaemonEndpoint(this.fluent.getPort());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DaemonEndpointBuilder that = (DaemonEndpointBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

