/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ContainerState;
import io.fabric8.kubernetes.api.model.ContainerStateFluent;
import io.fabric8.kubernetes.api.model.ContainerStateFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ContainerStateBuilder
extends ContainerStateFluentImpl<ContainerStateBuilder>
implements VisitableBuilder<ContainerState, ContainerStateBuilder> {
    ContainerStateFluent<?> fluent;

    public ContainerStateBuilder() {
        this(new ContainerState());
    }

    public ContainerStateBuilder(ContainerStateFluent<?> fluent) {
        this(fluent, new ContainerState());
    }

    public ContainerStateBuilder(ContainerStateFluent<?> fluent, ContainerState instance) {
        this.fluent = fluent;
        fluent.withRunning(instance.getRunning());
        fluent.withTerminated(instance.getTerminated());
        fluent.withWaiting(instance.getWaiting());
    }

    public ContainerStateBuilder(ContainerState instance) {
        this.fluent = this;
        this.withRunning(instance.getRunning());
        this.withTerminated(instance.getTerminated());
        this.withWaiting(instance.getWaiting());
    }

    public ContainerState build() {
        ContainerState buildable = new ContainerState(this.fluent.getRunning(), this.fluent.getTerminated(), this.fluent.getWaiting());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerStateBuilder that = (ContainerStateBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

