/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.model.Cluster;
import io.fabric8.kubernetes.api.model.NamedExtension;
import io.fabric8.kubernetes.api.model.NamedExtensionAssert;
import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.BooleanAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.StringAssert;

public abstract class AbstractClusterAssert<S extends AbstractClusterAssert<S, A>, A extends Cluster>
extends AbstractAssert<S, A> {
    protected AbstractClusterAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public MapAssert additionalProperties() {
        this.isNotNull();
        return (MapAssert)Assertions.assertThat(((Cluster)this.actual).getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"), new Object[0]);
    }

    public StringAssert apiVersion() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((Cluster)this.actual).getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"), new Object[0]);
    }

    public StringAssert certificateAuthority() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((Cluster)this.actual).getCertificateAuthority()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "certificateAuthority"), new Object[0]);
    }

    public StringAssert certificateAuthorityData() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((Cluster)this.actual).getCertificateAuthorityData()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "certificateAuthorityData"), new Object[0]);
    }

    public NavigationListAssert<NamedExtension, NamedExtensionAssert> extensions() {
        this.isNotNull();
        AssertFactory<NamedExtension, NamedExtensionAssert> assertFactory = new AssertFactory<NamedExtension, NamedExtensionAssert>(){

            @Override
            public NamedExtensionAssert createAssert(NamedExtension t) {
                return io.fabric8.openshift.assertions.Assertions.assertThat(t);
            }
        };
        NavigationListAssert<NamedExtension, NamedExtensionAssert> answer = new NavigationListAssert<NamedExtension, NamedExtensionAssert>(((Cluster)this.actual).getExtensions(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "extensions"), new Object[0]);
        return answer;
    }

    public BooleanAssert insecureSkipTlsVerify() {
        this.isNotNull();
        return (BooleanAssert)Assertions.assertThat((Boolean)((Cluster)this.actual).getInsecureSkipTlsVerify()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "insecureSkipTlsVerify"), new Object[0]);
    }

    public StringAssert server() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((Cluster)this.actual).getServer()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "server"), new Object[0]);
    }
}

