/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.EditableSourceRevision;
import io.fabric8.openshift.api.model.SourceRevision;
import io.fabric8.openshift.api.model.SourceRevisionFluent;
import io.fabric8.openshift.api.model.SourceRevisionFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class SourceRevisionBuilder
extends SourceRevisionFluentImpl<SourceRevisionBuilder>
implements VisitableBuilder<SourceRevision, SourceRevisionBuilder> {
    SourceRevisionFluent<?> fluent;

    public SourceRevisionBuilder() {
        this(new SourceRevision());
    }

    public SourceRevisionBuilder(SourceRevisionFluent<?> fluent) {
        this(fluent, new SourceRevision());
    }

    public SourceRevisionBuilder(SourceRevisionFluent<?> fluent, SourceRevision instance) {
        this.fluent = fluent;
        fluent.withGit(instance.getGit());
        fluent.withType(instance.getType());
    }

    public SourceRevisionBuilder(SourceRevision instance) {
        this.fluent = this;
        this.withGit(instance.getGit());
        this.withType(instance.getType());
    }

    public EditableSourceRevision build() {
        EditableSourceRevision buildable = new EditableSourceRevision(this.fluent.getGit(), this.fluent.getType());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SourceRevisionBuilder that = (SourceRevisionBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

