/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.openshift.api.model.BinaryBuildSource;
import io.fabric8.openshift.api.model.BuildSource;
import io.fabric8.openshift.api.model.GitBuildSource;
import io.fabric8.openshift.api.model.ImageSource;
import io.fabric8.openshift.api.model.SecretBuildSource;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

public abstract class AbstractBuildSourceAssert<S extends AbstractBuildSourceAssert<S, A>, A extends BuildSource>
extends AbstractAssert<S, A> {
    protected AbstractBuildSourceAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasAdditionalProperties(Map additionalProperties) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Map<String, Object> actualAdditionalProperties = ((BuildSource)this.actual).getAdditionalProperties();
        if (!Objects.areEqual(actualAdditionalProperties, (Object)additionalProperties)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, additionalProperties, actualAdditionalProperties});
        }
        return (S)((Object)((AbstractBuildSourceAssert)this.myself));
    }

    public S hasBinary(BinaryBuildSource binary) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting binary of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        BinaryBuildSource actualBinary = ((BuildSource)this.actual).getBinary();
        if (!Objects.areEqual((Object)actualBinary, (Object)binary)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, binary, actualBinary});
        }
        return (S)((Object)((AbstractBuildSourceAssert)this.myself));
    }

    public S hasContextDir(String contextDir) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting contextDir of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualContextDir = ((BuildSource)this.actual).getContextDir();
        if (!Objects.areEqual((Object)actualContextDir, (Object)contextDir)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, contextDir, actualContextDir});
        }
        return (S)((Object)((AbstractBuildSourceAssert)this.myself));
    }

    public S hasDockerfile(String dockerfile) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting dockerfile of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualDockerfile = ((BuildSource)this.actual).getDockerfile();
        if (!Objects.areEqual((Object)actualDockerfile, (Object)dockerfile)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, dockerfile, actualDockerfile});
        }
        return (S)((Object)((AbstractBuildSourceAssert)this.myself));
    }

    public S hasGit(GitBuildSource git) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting git of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        GitBuildSource actualGit = ((BuildSource)this.actual).getGit();
        if (!Objects.areEqual((Object)actualGit, (Object)git)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, git, actualGit});
        }
        return (S)((Object)((AbstractBuildSourceAssert)this.myself));
    }

    public S hasImages(ImageSource ... images) {
        this.isNotNull();
        if (images == null) {
            this.failWithMessage("Expecting images parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, ((BuildSource)this.actual).getImages(), (Object[])images);
        return (S)((Object)((AbstractBuildSourceAssert)this.myself));
    }

    public S hasOnlyImages(ImageSource ... images) {
        this.isNotNull();
        if (images == null) {
            this.failWithMessage("Expecting images parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, ((BuildSource)this.actual).getImages(), (Object[])images);
        return (S)((Object)((AbstractBuildSourceAssert)this.myself));
    }

    public S doesNotHaveImages(ImageSource ... images) {
        this.isNotNull();
        if (images == null) {
            this.failWithMessage("Expecting images parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, ((BuildSource)this.actual).getImages(), (Object[])images);
        return (S)((Object)((AbstractBuildSourceAssert)this.myself));
    }

    public S hasNoImages() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have images but had :\n  <%s>";
        if (((BuildSource)this.actual).getImages().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((BuildSource)this.actual).getImages()});
        }
        return (S)((Object)((AbstractBuildSourceAssert)this.myself));
    }

    public S hasSecrets(SecretBuildSource ... secrets) {
        this.isNotNull();
        if (secrets == null) {
            this.failWithMessage("Expecting secrets parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, ((BuildSource)this.actual).getSecrets(), (Object[])secrets);
        return (S)((Object)((AbstractBuildSourceAssert)this.myself));
    }

    public S hasOnlySecrets(SecretBuildSource ... secrets) {
        this.isNotNull();
        if (secrets == null) {
            this.failWithMessage("Expecting secrets parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, ((BuildSource)this.actual).getSecrets(), (Object[])secrets);
        return (S)((Object)((AbstractBuildSourceAssert)this.myself));
    }

    public S doesNotHaveSecrets(SecretBuildSource ... secrets) {
        this.isNotNull();
        if (secrets == null) {
            this.failWithMessage("Expecting secrets parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, ((BuildSource)this.actual).getSecrets(), (Object[])secrets);
        return (S)((Object)((AbstractBuildSourceAssert)this.myself));
    }

    public S hasNoSecrets() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have secrets but had :\n  <%s>";
        if (((BuildSource)this.actual).getSecrets().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((BuildSource)this.actual).getSecrets()});
        }
        return (S)((Object)((AbstractBuildSourceAssert)this.myself));
    }

    public S hasSourceSecret(LocalObjectReference sourceSecret) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting sourceSecret of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        LocalObjectReference actualSourceSecret = ((BuildSource)this.actual).getSourceSecret();
        if (!Objects.areEqual((Object)actualSourceSecret, (Object)sourceSecret)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, sourceSecret, actualSourceSecret});
        }
        return (S)((Object)((AbstractBuildSourceAssert)this.myself));
    }

    public S hasType(String type) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting type of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualType = ((BuildSource)this.actual).getType();
        if (!Objects.areEqual((Object)actualType, (Object)type)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, type, actualType});
        }
        return (S)((Object)((AbstractBuildSourceAssert)this.myself));
    }
}

