/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.DaemonSet;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetFluent;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetSpec;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecBuilder;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetStatus;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetStatusBuilder;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetStatusFluentImpl;
import java.util.HashMap;
import java.util.Map;

public class DaemonSetFluentImpl<T extends DaemonSetFluent<T>>
extends BaseFluent<T>
implements DaemonSetFluent<T> {
    String apiVersion;
    String kind;
    VisitableBuilder<ObjectMeta, ?> metadata;
    VisitableBuilder<DaemonSetSpec, ?> spec;
    VisitableBuilder<DaemonSetStatus, ?> status;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public DaemonSetFluentImpl() {
    }

    public DaemonSetFluentImpl(DaemonSet instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public T withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public T withKind(String kind) {
        this.kind = kind;
        return (T)this;
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public T withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)this;
    }

    @Override
    public DaemonSetFluent.MetadataNested<T> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public DaemonSetFluent.MetadataNested<T> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public DaemonSetFluent.MetadataNested<T> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public DaemonSetSpec getSpec() {
        return this.spec != null ? (DaemonSetSpec)this.spec.build() : null;
    }

    @Override
    public T withSpec(DaemonSetSpec spec) {
        if (spec != null) {
            this.spec = new DaemonSetSpecBuilder(spec);
            this._visitables.add(this.spec);
        }
        return (T)this;
    }

    @Override
    public DaemonSetFluent.SpecNested<T> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public DaemonSetFluent.SpecNested<T> withNewSpecLike(DaemonSetSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public DaemonSetFluent.SpecNested<T> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public DaemonSetStatus getStatus() {
        return this.status != null ? (DaemonSetStatus)this.status.build() : null;
    }

    @Override
    public T withStatus(DaemonSetStatus status) {
        if (status != null) {
            this.status = new DaemonSetStatusBuilder(status);
            this._visitables.add(this.status);
        }
        return (T)this;
    }

    @Override
    public DaemonSetFluent.StatusNested<T> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public DaemonSetFluent.StatusNested<T> withNewStatusLike(DaemonSetStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public DaemonSetFluent.StatusNested<T> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public T withNewStatus(Integer currentNumberScheduled, Integer desiredNumberScheduled, Integer numberMisscheduled) {
        return this.withStatus(new DaemonSetStatus(currentNumberScheduled, desiredNumberScheduled, numberMisscheduled));
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DaemonSetFluentImpl that = (DaemonSetFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        if (this.status != null ? !this.status.equals(that.status) : that.status != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class StatusNestedImpl<N>
    extends DaemonSetStatusFluentImpl<DaemonSetFluent.StatusNested<N>>
    implements DaemonSetFluent.StatusNested<N> {
        private final DaemonSetStatusBuilder builder;

        StatusNestedImpl() {
            this.builder = new DaemonSetStatusBuilder(this);
        }

        StatusNestedImpl(DaemonSetStatus item) {
            this.builder = new DaemonSetStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)DaemonSetFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends DaemonSetSpecFluentImpl<DaemonSetFluent.SpecNested<N>>
    implements DaemonSetFluent.SpecNested<N> {
        private final DaemonSetSpecBuilder builder;

        SpecNestedImpl() {
            this.builder = new DaemonSetSpecBuilder(this);
        }

        SpecNestedImpl(DaemonSetSpec item) {
            this.builder = new DaemonSetSpecBuilder(this, item);
        }

        @Override
        public N endSpec() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)DaemonSetFluentImpl.this.withSpec(this.builder.build());
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<DaemonSetFluent.MetadataNested<N>>
    implements DaemonSetFluent.MetadataNested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)DaemonSetFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

