/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.model.HTTPGetAction;
import io.fabric8.kubernetes.api.model.HTTPHeader;
import io.fabric8.kubernetes.api.model.IntOrString;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

public abstract class AbstractHTTPGetActionAssert<S extends AbstractHTTPGetActionAssert<S, A>, A extends HTTPGetAction>
extends AbstractAssert<S, A> {
    protected AbstractHTTPGetActionAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasAdditionalProperties(Map additionalProperties) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Map<String, Object> actualAdditionalProperties = ((HTTPGetAction)this.actual).getAdditionalProperties();
        if (!Objects.areEqual(actualAdditionalProperties, (Object)additionalProperties)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, additionalProperties, actualAdditionalProperties});
        }
        return (S)((Object)((AbstractHTTPGetActionAssert)this.myself));
    }

    public S hasHost(String host) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting host of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualHost = ((HTTPGetAction)this.actual).getHost();
        if (!Objects.areEqual((Object)actualHost, (Object)host)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, host, actualHost});
        }
        return (S)((Object)((AbstractHTTPGetActionAssert)this.myself));
    }

    public S hasHttpHeaders(HTTPHeader ... httpHeaders) {
        this.isNotNull();
        if (httpHeaders == null) {
            this.failWithMessage("Expecting httpHeaders parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, ((HTTPGetAction)this.actual).getHttpHeaders(), (Object[])httpHeaders);
        return (S)((Object)((AbstractHTTPGetActionAssert)this.myself));
    }

    public S hasOnlyHttpHeaders(HTTPHeader ... httpHeaders) {
        this.isNotNull();
        if (httpHeaders == null) {
            this.failWithMessage("Expecting httpHeaders parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, ((HTTPGetAction)this.actual).getHttpHeaders(), (Object[])httpHeaders);
        return (S)((Object)((AbstractHTTPGetActionAssert)this.myself));
    }

    public S doesNotHaveHttpHeaders(HTTPHeader ... httpHeaders) {
        this.isNotNull();
        if (httpHeaders == null) {
            this.failWithMessage("Expecting httpHeaders parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, ((HTTPGetAction)this.actual).getHttpHeaders(), (Object[])httpHeaders);
        return (S)((Object)((AbstractHTTPGetActionAssert)this.myself));
    }

    public S hasNoHttpHeaders() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have httpHeaders but had :\n  <%s>";
        if (((HTTPGetAction)this.actual).getHttpHeaders().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((HTTPGetAction)this.actual).getHttpHeaders()});
        }
        return (S)((Object)((AbstractHTTPGetActionAssert)this.myself));
    }

    public S hasPath(String path) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting path of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualPath = ((HTTPGetAction)this.actual).getPath();
        if (!Objects.areEqual((Object)actualPath, (Object)path)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, path, actualPath});
        }
        return (S)((Object)((AbstractHTTPGetActionAssert)this.myself));
    }

    public S hasPort(IntOrString port) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting port of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        IntOrString actualPort = ((HTTPGetAction)this.actual).getPort();
        if (!Objects.areEqual((Object)actualPort, (Object)port)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, port, actualPort});
        }
        return (S)((Object)((AbstractHTTPGetActionAssert)this.myself));
    }

    public S hasScheme(String scheme) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting scheme of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualScheme = ((HTTPGetAction)this.actual).getScheme();
        if (!Objects.areEqual((Object)actualScheme, (Object)scheme)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, scheme, actualScheme});
        }
        return (S)((Object)((AbstractHTTPGetActionAssert)this.myself));
    }
}

