/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpec;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ReplicationControllerSpecBuilder
extends ReplicationControllerSpecFluent<ReplicationControllerSpecBuilder>
implements VisitableBuilder<ReplicationControllerSpec, ReplicationControllerSpecBuilder> {
    ReplicationControllerSpecFluent<?> fluent;

    public ReplicationControllerSpecBuilder() {
        this(new ReplicationControllerSpec());
    }

    public ReplicationControllerSpecBuilder(ReplicationControllerSpecFluent<?> fluent) {
        this(fluent, new ReplicationControllerSpec());
    }

    public ReplicationControllerSpecBuilder(ReplicationControllerSpecFluent<?> fluent, ReplicationControllerSpec instance) {
        this.fluent = fluent;
        fluent.withReplicas(instance.getReplicas());
        fluent.withSelector(instance.getSelector());
        fluent.withTemplate(instance.getTemplate());
        fluent.withTemplateRef(instance.getTemplateRef());
    }

    public ReplicationControllerSpecBuilder(ReplicationControllerSpec instance) {
        this.fluent = this;
        this.withReplicas(instance.getReplicas());
        this.withSelector(instance.getSelector());
        this.withTemplate(instance.getTemplate());
        this.withTemplateRef(instance.getTemplateRef());
    }

    public ReplicationControllerSpec build() {
        ReplicationControllerSpec buildable = new ReplicationControllerSpec(this.fluent.getReplicas(), this.fluent.getSelector(), this.fluent.getTemplate(), this.fluent.getTemplateRef());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

