/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.BaseFluent;
import io.fabric8.common.Fluent;
import io.fabric8.common.Nested;
import io.fabric8.common.VisitableBuilder;
import io.fabric8.kubernetes.api.model.NodeAddress;
import io.fabric8.kubernetes.api.model.NodeAddressBuilder;
import io.fabric8.kubernetes.api.model.NodeAddressFluent;
import io.fabric8.kubernetes.api.model.NodeCondition;
import io.fabric8.kubernetes.api.model.NodeConditionBuilder;
import io.fabric8.kubernetes.api.model.NodeConditionFluent;
import io.fabric8.kubernetes.api.model.NodeSystemInfo;
import io.fabric8.kubernetes.api.model.NodeSystemInfoBuilder;
import io.fabric8.kubernetes.api.model.NodeSystemInfoFluent;
import io.fabric8.kubernetes.api.model.resource.Quantity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NodeStatusFluent<T extends NodeStatusFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    List<VisitableBuilder<NodeAddress, ?>> addresses = new ArrayList();
    Map<String, Quantity> capacity = new HashMap<String, Quantity>();
    List<VisitableBuilder<NodeCondition, ?>> conditions = new ArrayList();
    VisitableBuilder<NodeSystemInfo, ?> nodeInfo;
    String phase;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public T addToAddresses(NodeAddress item) {
        if (item != null) {
            NodeAddressBuilder builder = new NodeAddressBuilder(item);
            this._visitables.add(builder);
            this.addresses.add(builder);
        }
        return (T)((Object)this);
    }

    public List<NodeAddress> getAddresses() {
        return this.build(this.addresses);
    }

    public T withAddresses(List<NodeAddress> addresses) {
        this.addresses.clear();
        if (addresses != null) {
            for (NodeAddress item : addresses) {
                this.addToAddresses(item);
            }
        }
        return (T)((Object)this);
    }

    public AddressesNested<T> addNewAddresse() {
        return new AddressesNested();
    }

    public AddressesNested<T> addNewAddresseLike(NodeAddress item) {
        return new AddressesNested(item);
    }

    public T addNewAddresse(String address, String type) {
        return this.addToAddresses(new NodeAddress(address, type));
    }

    public T addToCapacity(String key, Quantity value) {
        if (key != null && value != null) {
            this.capacity.put(key, value);
        }
        return (T)((Object)this);
    }

    public Map<String, Quantity> getCapacity() {
        return this.capacity;
    }

    public T withCapacity(Map<String, Quantity> capacity) {
        this.capacity.clear();
        if (capacity != null) {
            this.capacity.putAll(capacity);
        }
        return (T)((Object)this);
    }

    public T addToConditions(NodeCondition item) {
        if (item != null) {
            NodeConditionBuilder builder = new NodeConditionBuilder(item);
            this._visitables.add(builder);
            this.conditions.add(builder);
        }
        return (T)((Object)this);
    }

    public List<NodeCondition> getConditions() {
        return this.build(this.conditions);
    }

    public T withConditions(List<NodeCondition> conditions) {
        this.conditions.clear();
        if (conditions != null) {
            for (NodeCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (T)((Object)this);
    }

    public ConditionsNested<T> addNewCondition() {
        return new ConditionsNested();
    }

    public ConditionsNested<T> addNewConditionLike(NodeCondition item) {
        return new ConditionsNested(item);
    }

    public NodeSystemInfo getNodeInfo() {
        return this.nodeInfo != null ? (NodeSystemInfo)this.nodeInfo.build() : null;
    }

    public T withNodeInfo(NodeSystemInfo nodeInfo) {
        if (nodeInfo != null) {
            this.nodeInfo = new NodeSystemInfoBuilder(nodeInfo);
            this._visitables.add(this.nodeInfo);
        }
        return (T)((Object)this);
    }

    public NodeInfoNested<T> withNewNodeInfo() {
        return new NodeInfoNested();
    }

    public NodeInfoNested<T> withNewNodeInfoLike(NodeSystemInfo item) {
        return new NodeInfoNested(item);
    }

    public NodeInfoNested<T> editNodeInfo() {
        return this.withNewNodeInfoLike(this.getNodeInfo());
    }

    public String getPhase() {
        return this.phase;
    }

    public T withPhase(String phase) {
        this.phase = phase;
        return (T)((Object)this);
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)((Object)this);
    }

    public class NodeInfoNested<N>
    extends NodeSystemInfoFluent<NodeInfoNested<N>>
    implements Nested<N> {
        private final NodeSystemInfoBuilder builder;

        NodeInfoNested() {
            this.builder = new NodeSystemInfoBuilder(this);
        }

        NodeInfoNested(NodeSystemInfo item) {
            this.builder = new NodeSystemInfoBuilder(this, item);
        }

        public N and() {
            return (N)NodeStatusFluent.this.withNodeInfo(this.builder.build());
        }

        public N endNodeInfo() {
            return this.and();
        }
    }

    public class ConditionsNested<N>
    extends NodeConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        private final NodeConditionBuilder builder;

        ConditionsNested() {
            this.builder = new NodeConditionBuilder(this);
        }

        ConditionsNested(NodeCondition item) {
            this.builder = new NodeConditionBuilder(this, item);
        }

        public N and() {
            return (N)NodeStatusFluent.this.addToConditions(this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }

    public class AddressesNested<N>
    extends NodeAddressFluent<AddressesNested<N>>
    implements Nested<N> {
        private final NodeAddressBuilder builder;

        AddressesNested(NodeAddress item) {
            this.builder = new NodeAddressBuilder(this, item);
        }

        AddressesNested() {
            this.builder = new NodeAddressBuilder(this);
        }

        public N endAddresse() {
            return this.and();
        }

        public N and() {
            return (N)NodeStatusFluent.this.addToAddresses(this.builder.build());
        }
    }
}

