/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.BaseFluent;
import io.fabric8.common.Fluent;
import io.fabric8.common.Nested;
import io.fabric8.common.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpec;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpecBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluent;
import io.fabric8.kubernetes.api.model.ReplicationControllerStatus;
import io.fabric8.kubernetes.api.model.ReplicationControllerStatusBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerStatusFluent;
import java.util.HashMap;
import java.util.Map;

public class ReplicationControllerFluent<T extends ReplicationControllerFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    ReplicationController.ApiVersion apiVersion;
    String kind;
    VisitableBuilder<ObjectMeta, ?> metadata;
    VisitableBuilder<ReplicationControllerSpec, ?> spec;
    VisitableBuilder<ReplicationControllerStatus, ?> status;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public ReplicationController.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public T withApiVersion(ReplicationController.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)((Object)this);
    }

    public String getKind() {
        return this.kind;
    }

    public T withKind(String kind) {
        this.kind = kind;
        return (T)((Object)this);
    }

    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    public T withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)((Object)this);
    }

    public MetadataNested<T> withNewMetadata() {
        return new MetadataNested();
    }

    public ReplicationControllerSpec getSpec() {
        return this.spec != null ? (ReplicationControllerSpec)this.spec.build() : null;
    }

    public T withSpec(ReplicationControllerSpec spec) {
        if (spec != null) {
            this.spec = new ReplicationControllerSpecBuilder(spec);
            this._visitables.add(this.spec);
        }
        return (T)((Object)this);
    }

    public SpecNested<T> withNewSpec() {
        return new SpecNested();
    }

    public ReplicationControllerStatus getStatus() {
        return this.status != null ? (ReplicationControllerStatus)this.status.build() : null;
    }

    public T withStatus(ReplicationControllerStatus status) {
        if (status != null) {
            this.status = new ReplicationControllerStatusBuilder(status);
            this._visitables.add(this.status);
        }
        return (T)((Object)this);
    }

    public StatusNested<T> withNewStatus() {
        return new StatusNested();
    }

    public T withNewStatus(Integer replicas) {
        return this.withStatus(new ReplicationControllerStatus(replicas));
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)((Object)this);
    }

    public class StatusNested<N>
    extends ReplicationControllerStatusFluent<StatusNested<N>>
    implements Nested<N> {
        private final ReplicationControllerStatusBuilder builder = new ReplicationControllerStatusBuilder(this);

        public N endStatus() {
            return this.and();
        }

        public N and() {
            return (N)ReplicationControllerFluent.this.withStatus(this.builder.build());
        }
    }

    public class SpecNested<N>
    extends ReplicationControllerSpecFluent<SpecNested<N>>
    implements Nested<N> {
        private final ReplicationControllerSpecBuilder builder = new ReplicationControllerSpecBuilder(this);

        public N endSpec() {
            return this.and();
        }

        public N and() {
            return (N)ReplicationControllerFluent.this.withSpec(this.builder.build());
        }
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        private final ObjectMetaBuilder builder = new ObjectMetaBuilder(this);

        public N endMetadata() {
            return this.and();
        }

        public N and() {
            return (N)ReplicationControllerFluent.this.withMetadata(this.builder.build());
        }
    }
}

