/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"apiVersion", "data", "kind", "metadata", "type"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Secret
implements HasMetadata {
    @JsonProperty(value="apiVersion")
    @NotNull
    private ApiVersion apiVersion = ApiVersion.fromValue("v1beta3");
    @JsonProperty(value="data")
    @Valid
    private Map<String, String> data;
    @JsonProperty(value="kind")
    @NotNull
    private String kind = "Secret";
    @JsonProperty(value="metadata")
    @Valid
    private ObjectMeta metadata;
    @JsonProperty(value="type")
    private String type;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public Secret() {
    }

    public Secret(ApiVersion apiVersion, Map<String, String> data, String kind, ObjectMeta metadata, String type) {
        this.apiVersion = apiVersion;
        this.data = data;
        this.kind = kind;
        this.metadata = metadata;
        this.type = type;
    }

    @JsonProperty(value="apiVersion")
    public ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    @JsonProperty(value="apiVersion")
    public void setApiVersion(ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
    }

    @JsonProperty(value="data")
    public Map<String, String> getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    public void setData(Map<String, String> data) {
        this.data = data;
    }

    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @JsonProperty(value="kind")
    public void setKind(String kind) {
        this.kind = kind;
    }

    @Override
    @JsonProperty(value="metadata")
    public ObjectMeta getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="metadata")
    public void setMetadata(ObjectMeta metadata) {
        this.metadata = metadata;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.apiVersion).append(this.data).append((Object)this.kind).append((Object)this.metadata).append((Object)this.type).append(this.additionalProperties).toHashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Secret)) {
            return false;
        }
        Secret rhs = (Secret)other;
        return new EqualsBuilder().append((Object)this.apiVersion, (Object)rhs.apiVersion).append(this.data, rhs.data).append((Object)this.kind, (Object)rhs.kind).append((Object)this.metadata, (Object)rhs.metadata).append((Object)this.type, (Object)rhs.type).append(this.additionalProperties, rhs.additionalProperties).isEquals();
    }

    public static enum ApiVersion {
        V_1_BETA_1("v1beta1"),
        V_1_BETA_2("v1beta2"),
        V_1_BETA_3("v1beta3"),
        V_1("v1");

        private final String value;
        private static Map<String, ApiVersion> constants;

        private ApiVersion(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static ApiVersion fromValue(String value) {
            ApiVersion constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            constants = new HashMap<String, ApiVersion>();
            for (ApiVersion c : ApiVersion.values()) {
                constants.put(c.value, c);
            }
        }
    }
}

