/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.Builder;
import io.fabric8.kubernetes.api.model.EndpointPort;
import io.fabric8.kubernetes.api.model.EndpointPortFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class EndpointPortBuilder
extends EndpointPortFluent<EndpointPortBuilder>
implements Builder<EndpointPort> {
    EndpointPortFluent<?> fluent;

    public EndpointPortBuilder() {
        this(new EndpointPort());
    }

    public EndpointPortBuilder(EndpointPortFluent<?> fluent) {
        this(fluent, new EndpointPort());
    }

    public EndpointPortBuilder(EndpointPortFluent<?> fluent, EndpointPort instance) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withPort(instance.getPort());
        fluent.withProtocol(instance.getProtocol());
    }

    public EndpointPortBuilder(EndpointPort instance) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withPort(instance.getPort());
        this.withProtocol(instance.getProtocol());
    }

    public EndpointPort build() {
        EndpointPort buildable = new EndpointPort(this.fluent.getName(), this.fluent.getPort(), this.fluent.getProtocol());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

