/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.Builder;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class PodSpecBuilder
extends PodSpecFluent<PodSpecBuilder>
implements Builder<PodSpec> {
    PodSpecFluent<?> fluent;

    public PodSpecBuilder() {
        this(new PodSpec());
    }

    public PodSpecBuilder(PodSpecFluent<?> fluent) {
        this(fluent, new PodSpec());
    }

    public PodSpecBuilder(PodSpecFluent<?> fluent, PodSpec instance) {
        this.fluent = fluent;
        fluent.withContainers(instance.getContainers());
        fluent.withDnsPolicy(instance.getDnsPolicy());
        fluent.withHost(instance.getHost());
        fluent.withHostNetwork(instance.getHostNetwork());
        fluent.withNodeSelector(instance.getNodeSelector());
        fluent.withRestartPolicy(instance.getRestartPolicy());
        fluent.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds());
        fluent.withVolumes(instance.getVolumes());
    }

    public PodSpecBuilder(PodSpec instance) {
        this.fluent = this;
        this.withContainers(instance.getContainers());
        this.withDnsPolicy(instance.getDnsPolicy());
        this.withHost(instance.getHost());
        this.withHostNetwork(instance.getHostNetwork());
        this.withNodeSelector(instance.getNodeSelector());
        this.withRestartPolicy(instance.getRestartPolicy());
        this.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds());
        this.withVolumes(instance.getVolumes());
    }

    public PodSpec build() {
        PodSpec buildable = new PodSpec(this.fluent.getContainers(), this.fluent.getDnsPolicy(), this.fluent.getHost(), this.fluent.isHostNetwork(), this.fluent.getNodeSelector(), this.fluent.getRestartPolicy(), this.fluent.getTerminationGracePeriodSeconds(), this.fluent.getVolumes());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

