/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.Builder;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesListFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class KubernetesListBuilder
extends KubernetesListFluent<KubernetesListBuilder>
implements Builder<KubernetesList> {
    KubernetesListFluent<?> fluent;

    public KubernetesListBuilder() {
        this(new KubernetesList());
    }

    public KubernetesListBuilder(KubernetesListFluent<?> fluent) {
        this(fluent, new KubernetesList());
    }

    public KubernetesListBuilder(KubernetesListFluent<?> fluent, KubernetesList instance) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withServices(instance.getServices());
        fluent.withReplicationControllers(instance.getReplicationControllers());
        fluent.withPods(instance.getPods());
        fluent.withBuildConfigs(instance.getBuildConfigs());
        fluent.withDeploymentConfigs(instance.getDeploymentConfigs());
        fluent.withImageStreams(instance.getImageStreams());
        fluent.withRoutes(instance.getRoutes());
        fluent.withTemplates(instance.getTemplates());
        fluent.withOAuthClients(instance.getOAuthClients());
        fluent.withOAuthClientAuthorizations(instance.getOAuthClientAuthorizations());
        fluent.withOAuthAccessTokens(instance.getOAuthAccessTokens());
        fluent.withNamespaces(instance.getNamespaces());
        fluent.withSecrets(instance.getSecrets());
    }

    public KubernetesListBuilder(KubernetesList instance) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withServices(instance.getServices());
        this.withReplicationControllers(instance.getReplicationControllers());
        this.withPods(instance.getPods());
        this.withBuildConfigs(instance.getBuildConfigs());
        this.withDeploymentConfigs(instance.getDeploymentConfigs());
        this.withImageStreams(instance.getImageStreams());
        this.withRoutes(instance.getRoutes());
        this.withTemplates(instance.getTemplates());
        this.withOAuthClients(instance.getOAuthClients());
        this.withOAuthClientAuthorizations(instance.getOAuthClientAuthorizations());
        this.withOAuthAccessTokens(instance.getOAuthAccessTokens());
        this.withNamespaces(instance.getNamespaces());
        this.withSecrets(instance.getSecrets());
    }

    public KubernetesList build() {
        KubernetesList buildable = new KubernetesList(this.fluent.getApiVersion(), this.fluent.getItems(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getServices(), this.fluent.getReplicationControllers(), this.fluent.getPods(), this.fluent.getBuildConfigs(), this.fluent.getDeploymentConfigs(), this.fluent.getImageStreams(), this.fluent.getRoutes(), this.fluent.getTemplates(), this.fluent.getOAuthClients(), this.fluent.getOAuthClientAuthorizations(), this.fluent.getOAuthAccessTokens(), this.fluent.getNamespaces(), this.fluent.getSecrets());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

