/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.errors;

import io.fabric8.common.Builder;
import io.fabric8.kubernetes.api.model.errors.StatusError;
import io.fabric8.kubernetes.api.model.errors.StatusErrorFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class StatusErrorBuilder
extends StatusErrorFluent<StatusErrorBuilder>
implements Builder<StatusError> {
    StatusErrorFluent<?> fluent;

    public StatusErrorBuilder() {
        this(new StatusError());
    }

    public StatusErrorBuilder(StatusErrorFluent<?> fluent) {
        this(fluent, new StatusError());
    }

    public StatusErrorBuilder(StatusErrorFluent<?> fluent, StatusError instance) {
        this.fluent = fluent;
        fluent.withErrStatus(instance.getErrStatus());
    }

    public StatusErrorBuilder(StatusError instance) {
        this.fluent = this;
        this.withErrStatus(instance.getErrStatus());
    }

    public StatusError build() {
        StatusError buildable = new StatusError(this.fluent.getErrStatus());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

