/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.Builder;
import io.fabric8.kubernetes.api.model.HTTPGetAction;
import io.fabric8.kubernetes.api.model.HTTPGetActionFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class HTTPGetActionBuilder
extends HTTPGetActionFluent<HTTPGetActionBuilder>
implements Builder<HTTPGetAction> {
    HTTPGetActionFluent<?> fluent;

    public HTTPGetActionBuilder() {
        this(new HTTPGetAction());
    }

    public HTTPGetActionBuilder(HTTPGetActionFluent<?> fluent) {
        this(fluent, new HTTPGetAction());
    }

    public HTTPGetActionBuilder(HTTPGetActionFluent<?> fluent, HTTPGetAction instance) {
        this.fluent = fluent;
        fluent.withHost(instance.getHost());
        fluent.withPath(instance.getPath());
        fluent.withPort(instance.getPort());
    }

    public HTTPGetActionBuilder(HTTPGetAction instance) {
        this.fluent = this;
        this.withHost(instance.getHost());
        this.withPath(instance.getPath());
        this.withPort(instance.getPort());
    }

    public HTTPGetAction build() {
        HTTPGetAction buildable = new HTTPGetAction(this.fluent.getHost(), this.fluent.getPath(), this.fluent.getPort());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

