/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.Builder;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.api.model.ServiceListFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ServiceListBuilder
extends ServiceListFluent<ServiceListBuilder>
implements Builder<ServiceList> {
    private final ServiceListFluent<?> fluent;

    public ServiceListBuilder() {
        this(new ServiceList());
    }

    public ServiceListBuilder(ServiceListFluent<?> fluent) {
        this(fluent, new ServiceList());
    }

    public ServiceListBuilder(ServiceListFluent<?> fluent, ServiceList instance) {
        this.fluent = fluent;
        fluent.withAnnotations(instance.getAnnotations());
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withCreationTimestamp(instance.getCreationTimestamp());
        fluent.withId(instance.getId());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withNamespace(instance.getNamespace());
        fluent.withResourceVersion(instance.getResourceVersion());
        fluent.withSelfLink(instance.getSelfLink());
        fluent.withUid(instance.getUid());
    }

    public ServiceListBuilder(ServiceList instance) {
        this.fluent = this;
        this.withAnnotations(instance.getAnnotations());
        this.withApiVersion(instance.getApiVersion());
        this.withCreationTimestamp(instance.getCreationTimestamp());
        this.withId(instance.getId());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withNamespace(instance.getNamespace());
        this.withResourceVersion(instance.getResourceVersion());
        this.withSelfLink(instance.getSelfLink());
        this.withUid(instance.getUid());
    }

    public ServiceList build() {
        ServiceList buildable = new ServiceList(this.fluent.getAnnotations(), this.fluent.getApiVersion(), this.fluent.getCreationTimestamp(), this.fluent.getId(), this.fluent.getItems(), this.fluent.getKind(), this.fluent.getNamespace(), this.fluent.getResourceVersion(), this.fluent.getSelfLink(), this.fluent.getUid());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

