/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.Builder;
import io.fabric8.kubernetes.api.model.RestartPolicy;
import io.fabric8.kubernetes.api.model.RestartPolicyFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class RestartPolicyBuilder
extends RestartPolicyFluent<RestartPolicyBuilder>
implements Builder<RestartPolicy> {
    private final RestartPolicyFluent<?> fluent;

    public RestartPolicyBuilder() {
        this(new RestartPolicy());
    }

    public RestartPolicyBuilder(RestartPolicyFluent<?> fluent) {
        this(fluent, new RestartPolicy());
    }

    public RestartPolicyBuilder(RestartPolicyFluent<?> fluent, RestartPolicy instance) {
        this.fluent = fluent;
        fluent.withAlways(instance.getAlways());
        fluent.withNever(instance.getNever());
        fluent.withOnFailure(instance.getOnFailure());
    }

    public RestartPolicyBuilder(RestartPolicy instance) {
        this.fluent = this;
        this.withAlways(instance.getAlways());
        this.withNever(instance.getNever());
        this.withOnFailure(instance.getOnFailure());
    }

    public RestartPolicy build() {
        RestartPolicy buildable = new RestartPolicy(this.fluent.getAlways(), this.fluent.getNever(), this.fluent.getOnFailure());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

