/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.Builder;
import io.fabric8.kubernetes.api.model.ReplicationControllerState;
import io.fabric8.kubernetes.api.model.ReplicationControllerStateFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ReplicationControllerStateBuilder
extends ReplicationControllerStateFluent<ReplicationControllerStateBuilder>
implements Builder<ReplicationControllerState> {
    private final ReplicationControllerStateFluent<?> fluent;

    public ReplicationControllerStateBuilder() {
        this(new ReplicationControllerState());
    }

    public ReplicationControllerStateBuilder(ReplicationControllerStateFluent<?> fluent) {
        this(fluent, new ReplicationControllerState());
    }

    public ReplicationControllerStateBuilder(ReplicationControllerStateFluent<?> fluent, ReplicationControllerState instance) {
        this.fluent = fluent;
        fluent.withPodTemplate(instance.getPodTemplate());
        fluent.withReplicaSelector(instance.getReplicaSelector());
        fluent.withReplicas(instance.getReplicas());
    }

    public ReplicationControllerStateBuilder(ReplicationControllerState instance) {
        this.fluent = this;
        this.withPodTemplate(instance.getPodTemplate());
        this.withReplicaSelector(instance.getReplicaSelector());
        this.withReplicas(instance.getReplicas());
    }

    public ReplicationControllerState build() {
        ReplicationControllerState buildable = new ReplicationControllerState(this.fluent.getPodTemplate(), this.fluent.getReplicaSelector(), this.fluent.getReplicas());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

