/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.Builder;
import io.fabric8.kubernetes.api.model.Port;
import io.fabric8.kubernetes.api.model.PortFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class PortBuilder
extends PortFluent<PortBuilder>
implements Builder<Port> {
    private final PortFluent<?> fluent;

    public PortBuilder() {
        this(new Port());
    }

    public PortBuilder(PortFluent<?> fluent) {
        this(fluent, new Port());
    }

    public PortBuilder(PortFluent<?> fluent, Port instance) {
        this.fluent = fluent;
        fluent.withContainerPort(instance.getContainerPort());
        fluent.withHostIP(instance.getHostIP());
        fluent.withHostPort(instance.getHostPort());
        fluent.withName(instance.getName());
        fluent.withProtocol(instance.getProtocol());
    }

    public PortBuilder(Port instance) {
        this.fluent = this;
        this.withContainerPort(instance.getContainerPort());
        this.withHostIP(instance.getHostIP());
        this.withHostPort(instance.getHostPort());
        this.withName(instance.getName());
        this.withProtocol(instance.getProtocol());
    }

    public Port build() {
        Port buildable = new Port(this.fluent.getContainerPort(), this.fluent.getHostIP(), this.fluent.getHostPort(), this.fluent.getName(), this.fluent.getProtocol());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

