/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.Builder;
import io.fabric8.kubernetes.api.model.PodTemplate;
import io.fabric8.kubernetes.api.model.PodTemplateFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class PodTemplateBuilder
extends PodTemplateFluent<PodTemplateBuilder>
implements Builder<PodTemplate> {
    private final PodTemplateFluent<?> fluent;

    public PodTemplateBuilder() {
        this(new PodTemplate());
    }

    public PodTemplateBuilder(PodTemplateFluent<?> fluent) {
        this(fluent, new PodTemplate());
    }

    public PodTemplateBuilder(PodTemplateFluent<?> fluent, PodTemplate instance) {
        this.fluent = fluent;
        fluent.withDesiredState(instance.getDesiredState());
        fluent.withLabels(instance.getLabels());
    }

    public PodTemplateBuilder(PodTemplate instance) {
        this.fluent = this;
        this.withDesiredState(instance.getDesiredState());
        this.withLabels(instance.getLabels());
    }

    public PodTemplate build() {
        PodTemplate buildable = new PodTemplate(this.fluent.getDesiredState(), this.fluent.getLabels());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

