/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.Builder;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class PodBuilder
extends PodFluent<PodBuilder>
implements Builder<Pod> {
    private final PodFluent<?> fluent;

    public PodBuilder() {
        this(new Pod());
    }

    public PodBuilder(PodFluent<?> fluent) {
        this(fluent, new Pod());
    }

    public PodBuilder(PodFluent<?> fluent, Pod instance) {
        this.fluent = fluent;
        fluent.withAnnotations(instance.getAnnotations());
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withCreationTimestamp(instance.getCreationTimestamp());
        fluent.withCurrentState(instance.getCurrentState());
        fluent.withDesiredState(instance.getDesiredState());
        fluent.withId(instance.getId());
        fluent.withKind(instance.getKind());
        fluent.withLabels(instance.getLabels());
        fluent.withNamespace(instance.getNamespace());
        fluent.withNodeSelector(instance.getNodeSelector());
        fluent.withResourceVersion(instance.getResourceVersion());
        fluent.withSelfLink(instance.getSelfLink());
        fluent.withUid(instance.getUid());
    }

    public PodBuilder(Pod instance) {
        this.fluent = this;
        this.withAnnotations(instance.getAnnotations());
        this.withApiVersion(instance.getApiVersion());
        this.withCreationTimestamp(instance.getCreationTimestamp());
        this.withCurrentState(instance.getCurrentState());
        this.withDesiredState(instance.getDesiredState());
        this.withId(instance.getId());
        this.withKind(instance.getKind());
        this.withLabels(instance.getLabels());
        this.withNamespace(instance.getNamespace());
        this.withNodeSelector(instance.getNodeSelector());
        this.withResourceVersion(instance.getResourceVersion());
        this.withSelfLink(instance.getSelfLink());
        this.withUid(instance.getUid());
    }

    public Pod build() {
        Pod buildable = new Pod(this.fluent.getAnnotations(), this.fluent.getApiVersion(), this.fluent.getCreationTimestamp(), this.fluent.getCurrentState(), this.fluent.getDesiredState(), this.fluent.getId(), this.fluent.getKind(), this.fluent.getLabels(), this.fluent.getNamespace(), this.fluent.getNodeSelector(), this.fluent.getResourceVersion(), this.fluent.getSelfLink(), this.fluent.getUid());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

