/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.Builder;
import io.fabric8.kubernetes.api.model.NodeStatus;
import io.fabric8.kubernetes.api.model.NodeStatusFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class NodeStatusBuilder
extends NodeStatusFluent<NodeStatusBuilder>
implements Builder<NodeStatus> {
    private final NodeStatusFluent<?> fluent;

    public NodeStatusBuilder() {
        this(new NodeStatus());
    }

    public NodeStatusBuilder(NodeStatusFluent<?> fluent) {
        this(fluent, new NodeStatus());
    }

    public NodeStatusBuilder(NodeStatusFluent<?> fluent, NodeStatus instance) {
        this.fluent = fluent;
        fluent.withConditions(instance.getConditions());
        fluent.withPhase(instance.getPhase());
    }

    public NodeStatusBuilder(NodeStatus instance) {
        this.fluent = this;
        this.withConditions(instance.getConditions());
        this.withPhase(instance.getPhase());
    }

    public NodeStatus build() {
        NodeStatus buildable = new NodeStatus(this.fluent.getConditions(), this.fluent.getPhase());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

