/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.Builder;
import io.fabric8.kubernetes.api.model.NodeResources;
import io.fabric8.kubernetes.api.model.NodeResourcesFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class NodeResourcesBuilder
extends NodeResourcesFluent<NodeResourcesBuilder>
implements Builder<NodeResources> {
    private final NodeResourcesFluent<?> fluent;

    public NodeResourcesBuilder() {
        this(new NodeResources());
    }

    public NodeResourcesBuilder(NodeResourcesFluent<?> fluent) {
        this(fluent, new NodeResources());
    }

    public NodeResourcesBuilder(NodeResourcesFluent<?> fluent, NodeResources instance) {
        this.fluent = fluent;
        fluent.withCapacity(instance.getCapacity());
    }

    public NodeResourcesBuilder(NodeResources instance) {
        this.fluent = this;
        this.withCapacity(instance.getCapacity());
    }

    public NodeResources build() {
        NodeResources buildable = new NodeResources(this.fluent.getCapacity());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

