/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.Builder;
import io.fabric8.kubernetes.api.model.Minion;
import io.fabric8.kubernetes.api.model.MinionFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class MinionBuilder
extends MinionFluent<MinionBuilder>
implements Builder<Minion> {
    private final MinionFluent<?> fluent;

    public MinionBuilder() {
        this(new Minion());
    }

    public MinionBuilder(MinionFluent<?> fluent) {
        this(fluent, new Minion());
    }

    public MinionBuilder(MinionFluent<?> fluent, Minion instance) {
        this.fluent = fluent;
        fluent.withAnnotations(instance.getAnnotations());
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withCreationTimestamp(instance.getCreationTimestamp());
        fluent.withHostIP(instance.getHostIP());
        fluent.withId(instance.getId());
        fluent.withKind(instance.getKind());
        fluent.withLabels(instance.getLabels());
        fluent.withNamespace(instance.getNamespace());
        fluent.withResourceVersion(instance.getResourceVersion());
        fluent.withResources(instance.getResources());
        fluent.withSelfLink(instance.getSelfLink());
        fluent.withStatus(instance.getStatus());
        fluent.withUid(instance.getUid());
    }

    public MinionBuilder(Minion instance) {
        this.fluent = this;
        this.withAnnotations(instance.getAnnotations());
        this.withApiVersion(instance.getApiVersion());
        this.withCreationTimestamp(instance.getCreationTimestamp());
        this.withHostIP(instance.getHostIP());
        this.withId(instance.getId());
        this.withKind(instance.getKind());
        this.withLabels(instance.getLabels());
        this.withNamespace(instance.getNamespace());
        this.withResourceVersion(instance.getResourceVersion());
        this.withResources(instance.getResources());
        this.withSelfLink(instance.getSelfLink());
        this.withStatus(instance.getStatus());
        this.withUid(instance.getUid());
    }

    public Minion build() {
        Minion buildable = new Minion(this.fluent.getAnnotations(), this.fluent.getApiVersion(), this.fluent.getCreationTimestamp(), this.fluent.getHostIP(), this.fluent.getId(), this.fluent.getKind(), this.fluent.getLabels(), this.fluent.getNamespace(), this.fluent.getResourceVersion(), this.fluent.getResources(), this.fluent.getSelfLink(), this.fluent.getStatus(), this.fluent.getUid());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

