/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.Builder;
import io.fabric8.kubernetes.api.model.GitRepo;
import io.fabric8.kubernetes.api.model.GitRepoFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class GitRepoBuilder
extends GitRepoFluent<GitRepoBuilder>
implements Builder<GitRepo> {
    private final GitRepoFluent<?> fluent;

    public GitRepoBuilder() {
        this(new GitRepo());
    }

    public GitRepoBuilder(GitRepoFluent<?> fluent) {
        this(fluent, new GitRepo());
    }

    public GitRepoBuilder(GitRepoFluent<?> fluent, GitRepo instance) {
        this.fluent = fluent;
        fluent.withRepository(instance.getRepository());
        fluent.withRevision(instance.getRevision());
    }

    public GitRepoBuilder(GitRepo instance) {
        this.fluent = this;
        this.withRepository(instance.getRepository());
        this.withRevision(instance.getRevision());
    }

    public GitRepo build() {
        GitRepo buildable = new GitRepo(this.fluent.getRepository(), this.fluent.getRevision());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

