/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.Builder;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class EnvVarBuilder
extends EnvVarFluent<EnvVarBuilder>
implements Builder<EnvVar> {
    private final EnvVarFluent<?> fluent;

    public EnvVarBuilder() {
        this(new EnvVar());
    }

    public EnvVarBuilder(EnvVarFluent<?> fluent) {
        this(fluent, new EnvVar());
    }

    public EnvVarBuilder(EnvVarFluent<?> fluent, EnvVar instance) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withValue(instance.getValue());
    }

    public EnvVarBuilder(EnvVar instance) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withValue(instance.getValue());
    }

    public EnvVar build() {
        EnvVar buildable = new EnvVar(this.fluent.getName(), this.fluent.getValue());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

