/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.Builder;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.ContainerStatusFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ContainerStatusBuilder
extends ContainerStatusFluent<ContainerStatusBuilder>
implements Builder<ContainerStatus> {
    private final ContainerStatusFluent<?> fluent;

    public ContainerStatusBuilder() {
        this(new ContainerStatus());
    }

    public ContainerStatusBuilder(ContainerStatusFluent<?> fluent) {
        this(fluent, new ContainerStatus());
    }

    public ContainerStatusBuilder(ContainerStatusFluent<?> fluent, ContainerStatus instance) {
        this.fluent = fluent;
        fluent.withContainerID(instance.getContainerID());
        fluent.withImage(instance.getImage());
        fluent.withPodIP(instance.getPodIP());
        fluent.withRestartCount(instance.getRestartCount());
        fluent.withState(instance.getState());
    }

    public ContainerStatusBuilder(ContainerStatus instance) {
        this.fluent = this;
        this.withContainerID(instance.getContainerID());
        this.withImage(instance.getImage());
        this.withPodIP(instance.getPodIP());
        this.withRestartCount(instance.getRestartCount());
        this.withState(instance.getState());
    }

    public ContainerStatus build() {
        ContainerStatus buildable = new ContainerStatus(this.fluent.getContainerID(), this.fluent.getImage(), this.fluent.getPodIP(), this.fluent.getRestartCount(), this.fluent.getState());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

