/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.Builder;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ContainerBuilder
extends ContainerFluent<ContainerBuilder>
implements Builder<Container> {
    private final ContainerFluent<?> fluent;

    public ContainerBuilder() {
        this(new Container());
    }

    public ContainerBuilder(ContainerFluent<?> fluent) {
        this(fluent, new Container());
    }

    public ContainerBuilder(ContainerFluent<?> fluent, Container instance) {
        this.fluent = fluent;
        fluent.withCommand(instance.getCommand());
        fluent.withCpu(instance.getCpu());
        fluent.withEnv(instance.getEnv());
        fluent.withImage(instance.getImage());
        fluent.withImagePullPolicy(instance.getImagePullPolicy());
        fluent.withLifecycle(instance.getLifecycle());
        fluent.withLivenessProbe(instance.getLivenessProbe());
        fluent.withMemory(instance.getMemory());
        fluent.withName(instance.getName());
        fluent.withPorts(instance.getPorts());
        fluent.withPrivileged(instance.getPrivileged());
        fluent.withTerminationMessagePath(instance.getTerminationMessagePath());
        fluent.withVolumeMounts(instance.getVolumeMounts());
        fluent.withWorkingDir(instance.getWorkingDir());
    }

    public ContainerBuilder(Container instance) {
        this.fluent = this;
        this.withCommand(instance.getCommand());
        this.withCpu(instance.getCpu());
        this.withEnv(instance.getEnv());
        this.withImage(instance.getImage());
        this.withImagePullPolicy(instance.getImagePullPolicy());
        this.withLifecycle(instance.getLifecycle());
        this.withLivenessProbe(instance.getLivenessProbe());
        this.withMemory(instance.getMemory());
        this.withName(instance.getName());
        this.withPorts(instance.getPorts());
        this.withPrivileged(instance.getPrivileged());
        this.withTerminationMessagePath(instance.getTerminationMessagePath());
        this.withVolumeMounts(instance.getVolumeMounts());
        this.withWorkingDir(instance.getWorkingDir());
    }

    public Container build() {
        Container buildable = new Container(this.fluent.getCommand(), this.fluent.getCpu(), this.fluent.getEnv(), this.fluent.getImage(), this.fluent.getImagePullPolicy(), this.fluent.getLifecycle(), this.fluent.getLivenessProbe(), this.fluent.getMemory(), this.fluent.getName(), this.fluent.getPorts(), this.fluent.isPrivileged(), this.fluent.getTerminationMessagePath(), this.fluent.getVolumeMounts(), this.fluent.getWorkingDir());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

