/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.Builder;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerFluent;

public class ContainerBuilder
extends ContainerFluent<ContainerBuilder>
implements Builder<Container> {
    private final ContainerFluent<?> fluent;

    public ContainerBuilder() {
        this.fluent = this;
    }

    public ContainerBuilder(ContainerFluent<?> fluent) {
        this.fluent = fluent;
    }

    public ContainerBuilder(Container instance) {
        this();
        this.withCommand(instance.getCommand());
        this.withCpu(instance.getCpu());
        this.withEnv(instance.getEnv());
        this.withImage(instance.getImage());
        this.withImagePullPolicy(instance.getImagePullPolicy());
        this.withLifecycle(instance.getLifecycle());
        this.withLivenessProbe(instance.getLivenessProbe());
        this.withMemory(instance.getMemory());
        this.withName(instance.getName());
        this.withPorts(instance.getPorts());
        this.withPrivileged(instance.getPrivileged());
        this.withTerminationMessagePath(instance.getTerminationMessagePath());
        this.withVolumeMounts(instance.getVolumeMounts());
        this.withWorkingDir(instance.getWorkingDir());
    }

    public Container build() {
        return new Container(this.fluent.getCommand(), this.fluent.getCpu(), this.fluent.getEnv(), this.fluent.getImage(), this.fluent.getImagePullPolicy(), this.fluent.getLifecycle(), this.fluent.getLivenessProbe(), this.fluent.getMemory(), this.fluent.getName(), this.fluent.getPorts(), this.fluent.isPrivileged(), this.fluent.getTerminationMessagePath(), this.fluent.getVolumeMounts(), this.fluent.getWorkingDir());
    }
}

