/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.assertions;

import io.fabric8.kubernetes.api.KubernetesClient;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodAssert;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodListAssert;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerAssert;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.ReplicationControllerListAssert;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceAssert;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.api.model.ServiceListAssert;
import io.fabric8.kubernetes.assertions.Assertions;
import io.fabric8.kubernetes.assertions.PodsAssert;
import java.util.List;
import javax.ws.rs.NotFoundException;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.ListAssert;

public class KubernetesAssert
extends AbstractAssert<KubernetesAssert, KubernetesClient> {
    private final KubernetesClient client;

    public KubernetesAssert(KubernetesClient client) {
        super((Object)client, KubernetesAssert.class);
        this.client = client;
    }

    public PodListAssert podList() {
        PodList pods = this.client.getPods();
        return (PodListAssert)Assertions.assertThat(pods).isNotNull();
    }

    public PodsAssert pods() {
        List<Pod> pods = this.getPods(null);
        return Assertions.assertThat(pods);
    }

    public PodsAssert pods(String namespace) {
        List<Pod> pods = this.getPods(namespace);
        return Assertions.assertThat(pods);
    }

    protected List<Pod> getPods(String namespace) {
        PodList podList = this.client.getPods(namespace);
        Assertions.assertThat(podList).isNotNull();
        List<Pod> pods = podList.getItems();
        Assertions.assertThat(pods).isNotNull();
        return pods;
    }

    public ReplicationControllerListAssert replicationControllerList() {
        ReplicationControllerList replicationControllers = this.client.getReplicationControllers();
        return (ReplicationControllerListAssert)Assertions.assertThat(replicationControllers).isNotNull();
    }

    public ReplicationControllerListAssert replicationControllerList(String namespace) {
        ReplicationControllerList replicationControllers = this.client.getReplicationControllers(namespace);
        return (ReplicationControllerListAssert)Assertions.assertThat(replicationControllers).isNotNull();
    }

    public ListAssert<ReplicationController> replicationControllers() {
        return this.replicationControllers(null);
    }

    public ListAssert<ReplicationController> replicationControllers(String namespace) {
        ReplicationControllerList replicationControllerList = this.client.getReplicationControllers(namespace);
        Assertions.assertThat(replicationControllerList).isNotNull();
        List<ReplicationController> replicationControllers = replicationControllerList.getItems();
        return (ListAssert)org.assertj.core.api.Assertions.assertThat(replicationControllers);
    }

    public ServiceListAssert serviceList() {
        ServiceList serviceList = this.client.getServices();
        return (ServiceListAssert)Assertions.assertThat(serviceList).isNotNull();
    }

    public ServiceListAssert serviceList(String namespace) {
        ServiceList serviceList = this.client.getServices(namespace);
        return (ServiceListAssert)Assertions.assertThat(serviceList).isNotNull();
    }

    public ListAssert<Service> services() {
        return this.services(null);
    }

    public ListAssert<Service> services(String namespace) {
        ServiceList serviceList = this.client.getServices(namespace);
        Assertions.assertThat(serviceList).isNotNull();
        List<Service> services = serviceList.getItems();
        return (ListAssert)org.assertj.core.api.Assertions.assertThat(services);
    }

    public PodsAssert podsForReplicationController(String replicationControllerId) {
        return this.podsForReplicationController(replicationControllerId, null);
    }

    public PodsAssert podsForReplicationController(String replicationControllerId, String namespace) {
        ReplicationController replicationController = this.getReplicationController(replicationControllerId, namespace);
        return this.podsForReplicationController(replicationController);
    }

    public PodsAssert podsForReplicationController(ReplicationController replicationController) {
        List<Pod> allPods = this.getPods(replicationController.getNamespace());
        List pods = KubernetesHelper.getPodsForReplicationController((ReplicationController)replicationController, allPods);
        return Assertions.assertThat(pods);
    }

    public PodsAssert podsForService(String serviceId) {
        Service service = this.getService(serviceId, null);
        return this.podsForService(service);
    }

    public PodsAssert podsForService(String serviceId, String namespace) {
        Service service = this.getService(serviceId, namespace);
        return this.podsForService(service);
    }

    public PodsAssert podsForService(Service service) {
        List<Pod> allPods = this.getPods(service.getNamespace());
        List pods = KubernetesHelper.getPodsForService((Service)service, allPods);
        return Assertions.assertThat(pods);
    }

    public ReplicationControllerAssert replicationController(String replicationControllerId) {
        return Assertions.assertThat(this.getReplicationController(replicationControllerId, null));
    }

    public ReplicationControllerAssert replicationController(String replicationControllerId, String namespace) {
        return Assertions.assertThat(this.getReplicationController(replicationControllerId, namespace));
    }

    protected ReplicationController getReplicationController(String replicationControllerId, String namespace) {
        org.assertj.core.api.Assertions.assertThat((String)replicationControllerId).isNotNull();
        ReplicationController replicationController = null;
        try {
            replicationController = this.client.getReplicationController(replicationControllerId, namespace);
        }
        catch (NotFoundException e) {
            org.assertj.core.api.Assertions.fail((String)("Could not find replicationController for '" + replicationControllerId + "'"));
        }
        Assertions.assertThat(replicationController).isNotNull();
        return replicationController;
    }

    public ServiceAssert service(String serviceId) {
        return Assertions.assertThat(this.getService(serviceId, null));
    }

    public ServiceAssert service(String serviceId, String namespace) {
        return Assertions.assertThat(this.getService(serviceId, namespace));
    }

    protected Service getService(String serviceId, String namespace) {
        org.assertj.core.api.Assertions.assertThat((String)serviceId).isNotNull();
        Service service = null;
        try {
            service = this.client.getService(serviceId, namespace);
        }
        catch (NotFoundException e) {
            org.assertj.core.api.Assertions.fail((String)("Could not find service for '" + serviceId + "'"));
        }
        Assertions.assertThat(service).isNotNull();
        return service;
    }

    public PodAssert pod(String podId) {
        return Assertions.assertThat(this.getPod(podId, null));
    }

    public PodAssert pod(String podId, String namespace) {
        return Assertions.assertThat(this.getPod(podId, namespace));
    }

    protected Pod getPod(String podId, String namespace) {
        org.assertj.core.api.Assertions.assertThat((String)podId).isNotNull();
        Pod pod = null;
        try {
            pod = this.client.getPod(namespace);
        }
        catch (NotFoundException e) {
            org.assertj.core.api.Assertions.fail((String)("Could not find pod for '" + podId + "'"));
        }
        Assertions.assertThat(pod).isNotNull();
        return pod;
    }
}

