/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.assertions;

import io.fabric8.kubernetes.api.KubernetesClient;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.PodListSchema;
import io.fabric8.kubernetes.api.model.PodListSchemaAssert;
import io.fabric8.kubernetes.api.model.PodSchema;
import io.fabric8.kubernetes.api.model.PodSchemaAssert;
import io.fabric8.kubernetes.api.model.ReplicationControllerListSchema;
import io.fabric8.kubernetes.api.model.ReplicationControllerListSchemaAssert;
import io.fabric8.kubernetes.api.model.ReplicationControllerSchema;
import io.fabric8.kubernetes.api.model.ReplicationControllerSchemaAssert;
import io.fabric8.kubernetes.api.model.ServiceListSchema;
import io.fabric8.kubernetes.api.model.ServiceListSchemaAssert;
import io.fabric8.kubernetes.api.model.ServiceSchema;
import io.fabric8.kubernetes.api.model.ServiceSchemaAssert;
import io.fabric8.kubernetes.assertions.Assertions;
import io.fabric8.kubernetes.assertions.PodsAssert;
import java.util.List;
import javax.ws.rs.NotFoundException;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.ListAssert;

public class KubernetesAssert
extends AbstractAssert<KubernetesAssert, KubernetesClient> {
    private final KubernetesClient client;

    public KubernetesAssert(KubernetesClient client) {
        super((Object)client, KubernetesAssert.class);
        this.client = client;
    }

    public PodListSchemaAssert podList() {
        PodListSchema pods = this.client.getPods();
        return (PodListSchemaAssert)Assertions.assertThat(pods).isNotNull();
    }

    public PodsAssert pods() {
        List<PodSchema> pods = this.getPods();
        return Assertions.assertThat(pods);
    }

    protected List<PodSchema> getPods() {
        PodListSchema podList = this.client.getPods();
        Assertions.assertThat(podList).isNotNull();
        List<PodSchema> pods = podList.getItems();
        Assertions.assertThat(pods).isNotNull();
        return pods;
    }

    public ReplicationControllerListSchemaAssert replicationControllerList() {
        ReplicationControllerListSchema replicationControllers = this.client.getReplicationControllers();
        return (ReplicationControllerListSchemaAssert)Assertions.assertThat(replicationControllers).isNotNull();
    }

    public ListAssert<ReplicationControllerSchema> replicationControllers() {
        ReplicationControllerListSchema replicationControllerList = this.client.getReplicationControllers();
        Assertions.assertThat(replicationControllerList).isNotNull();
        List<ReplicationControllerSchema> replicationControllers = replicationControllerList.getItems();
        return (ListAssert)org.assertj.core.api.Assertions.assertThat(replicationControllers);
    }

    public ServiceListSchemaAssert serviceList() {
        ServiceListSchema serviceList = this.client.getServices();
        return (ServiceListSchemaAssert)Assertions.assertThat(serviceList).isNotNull();
    }

    public ListAssert<ServiceSchema> services() {
        ServiceListSchema serviceList = this.client.getServices();
        Assertions.assertThat(serviceList).isNotNull();
        List<ServiceSchema> services = serviceList.getItems();
        return (ListAssert)org.assertj.core.api.Assertions.assertThat(services);
    }

    public PodsAssert podsForReplicationController(String replicationControllerId) {
        ReplicationControllerSchema replicationController = this.getReplicationController(replicationControllerId);
        return this.podsForReplicationController(replicationController);
    }

    public PodsAssert podsForReplicationController(ReplicationControllerSchema replicationController) {
        List<PodSchema> allPods = this.getPods();
        List pods = KubernetesHelper.getPodsForReplicationController((ReplicationControllerSchema)replicationController, allPods);
        return Assertions.assertThat(pods);
    }

    public PodsAssert podsForService(String serviceId) {
        ServiceSchema service = this.getService(serviceId);
        return this.podsForService(service);
    }

    public PodsAssert podsForService(ServiceSchema service) {
        List<PodSchema> allPods = this.getPods();
        List pods = KubernetesHelper.getPodsForService((ServiceSchema)service, allPods);
        return Assertions.assertThat(pods);
    }

    public ReplicationControllerSchemaAssert replicationController(String replicationControllerId) {
        return Assertions.assertThat(this.getReplicationController(replicationControllerId));
    }

    protected ReplicationControllerSchema getReplicationController(String replicationControllerId) {
        org.assertj.core.api.Assertions.assertThat((String)replicationControllerId).isNotNull();
        ReplicationControllerSchema replicationController = null;
        try {
            replicationController = this.client.getReplicationController(replicationControllerId);
        }
        catch (NotFoundException e) {
            org.assertj.core.api.Assertions.fail((String)("Could not find replicationController for '" + replicationControllerId + "'"));
        }
        Assertions.assertThat(replicationController).isNotNull();
        return replicationController;
    }

    public ServiceSchemaAssert service(String serviceId) {
        return Assertions.assertThat(this.getService(serviceId));
    }

    protected ServiceSchema getService(String serviceId) {
        org.assertj.core.api.Assertions.assertThat((String)serviceId).isNotNull();
        ServiceSchema service = null;
        try {
            service = this.client.getService(serviceId);
        }
        catch (NotFoundException e) {
            org.assertj.core.api.Assertions.fail((String)("Could not find service for '" + serviceId + "'"));
        }
        Assertions.assertThat(service).isNotNull();
        return service;
    }

    public PodSchemaAssert pod(String podId) {
        return Assertions.assertThat(this.getPod(podId));
    }

    protected PodSchema getPod(String podId) {
        org.assertj.core.api.Assertions.assertThat((String)podId).isNotNull();
        PodSchema pod = null;
        try {
            pod = this.client.getPod(podId);
        }
        catch (NotFoundException e) {
            org.assertj.core.api.Assertions.fail((String)("Could not find pod for '" + podId + "'"));
        }
        Assertions.assertThat(pod).isNotNull();
        return pod;
    }
}

