/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.model.Manifest;
import io.fabric8.kubernetes.api.model.ManifestContainer;
import io.fabric8.kubernetes.api.model.Volume;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

public abstract class AbstractManifestAssert<S extends AbstractManifestAssert<S, A>, A extends Manifest>
extends AbstractAssert<S, A> {
    protected AbstractManifestAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasAdditionalProperties(Map additionalProperties) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Map<String, Object> actualAdditionalProperties = ((Manifest)this.actual).getAdditionalProperties();
        if (!Objects.areEqual(actualAdditionalProperties, (Object)additionalProperties)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, additionalProperties, actualAdditionalProperties});
        }
        return (S)((Object)((AbstractManifestAssert)this.myself));
    }

    public S hasContainers(ManifestContainer ... containers) {
        this.isNotNull();
        if (containers == null) {
            throw new AssertionError((Object)"Expecting containers parameter not to be null.");
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, ((Manifest)this.actual).getContainers(), (Object[])containers);
        return (S)((Object)((AbstractManifestAssert)this.myself));
    }

    public S hasNoContainers() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have containers but had :\n  <%s>";
        if (((Manifest)this.actual).getContainers().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((Manifest)this.actual).getContainers()});
        }
        return (S)((Object)((AbstractManifestAssert)this.myself));
    }

    public S hasVersion(Manifest.Version version) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected version of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Manifest.Version actualVersion = ((Manifest)this.actual).getVersion();
        if (!Objects.areEqual((Object)((Object)actualVersion), (Object)((Object)version))) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, version, actualVersion});
        }
        return (S)((Object)((AbstractManifestAssert)this.myself));
    }

    public S hasVolumes(Volume ... volumes) {
        this.isNotNull();
        if (volumes == null) {
            throw new AssertionError((Object)"Expecting volumes parameter not to be null.");
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, ((Manifest)this.actual).getVolumes(), (Object[])volumes);
        return (S)((Object)((AbstractManifestAssert)this.myself));
    }

    public S hasNoVolumes() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have volumes but had :\n  <%s>";
        if (((Manifest)this.actual).getVolumes().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((Manifest)this.actual).getVolumes()});
        }
        return (S)((Object)((AbstractManifestAssert)this.myself));
    }
}

