/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.pipelines;

import io.fabric8.utils.Strings;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.lang.reflect.Method;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobEnvironment {
    private static final transient Logger LOG = LoggerFactory.getLogger(JobEnvironment.class);
    private String branchName;
    private String buildDisplayName;
    private String buildId;
    private String buildNumber;
    private String buildTag;
    private String buildUrl;
    private String jenkinsUrl;
    private String jobBaseName;
    private String jobDisplayUrl;
    private String jobName;
    private String jobUrl;
    private String gitUrl;

    public static JobEnvironment create(Map<String, String> map) throws IntrospectionException {
        JobEnvironment answer = new JobEnvironment();
        BeanInfo beanInfo = Introspector.getBeanInfo(JobEnvironment.class);
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        if (propertyDescriptors != null) {
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
                String name = propertyDescriptor.getName();
                String envVarName = JobEnvironment.propertyNameToEnvironmentVariableName(name);
                String value = map.get(envVarName);
                if (value == null) continue;
                PropertyEditor propertyEditor = propertyDescriptor.createPropertyEditor(answer);
                if (propertyEditor == null) {
                    Method writeMethod = propertyDescriptor.getWriteMethod();
                    if (writeMethod == null) {
                        LOG.warn("No PropertyEditor or WriteMethod for property: " + name);
                        continue;
                    }
                    Class<?>[] parameterTypes = writeMethod.getParameterTypes();
                    if (parameterTypes.length == 0 || !parameterTypes[0].equals(String.class)) {
                        LOG.warn("WriteMethod for property: " + name + " does not take a String and there is no PropertyEditor!");
                        continue;
                    }
                    try {
                        writeMethod.invoke((Object)answer, value);
                    }
                    catch (Exception e) {
                        LOG.warn("Failed to set property " + name + " due to: " + e, (Throwable)e);
                    }
                    continue;
                }
                propertyEditor.setAsText(value);
            }
        }
        return answer;
    }

    private static String propertyNameToEnvironmentVariableName(String name) {
        return Strings.splitCamelCase((String)name, (String)"_").toUpperCase();
    }

    public String toString() {
        return "JobEnvironment{buildId='" + this.buildId + '\'' + ", jobName='" + this.jobName + '\'' + ", gitUrl='" + this.gitUrl + '\'' + '}';
    }

    public String getBranchName() {
        return this.branchName;
    }

    public void setBranchName(String branchName) {
        this.branchName = branchName;
    }

    public String getBuildDisplayName() {
        return this.buildDisplayName;
    }

    public void setBuildDisplayName(String buildDisplayName) {
        this.buildDisplayName = buildDisplayName;
    }

    public String getBuildId() {
        return this.buildId;
    }

    public void setBuildId(String buildId) {
        this.buildId = buildId;
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public void setBuildNumber(String buildNumber) {
        this.buildNumber = buildNumber;
    }

    public String getBuildTag() {
        return this.buildTag;
    }

    public void setBuildTag(String buildTag) {
        this.buildTag = buildTag;
    }

    public String getBuildUrl() {
        return this.buildUrl;
    }

    public void setBuildUrl(String buildUrl) {
        this.buildUrl = buildUrl;
    }

    public String getJenkinsUrl() {
        return this.jenkinsUrl;
    }

    public void setJenkinsUrl(String jenkinsUrl) {
        this.jenkinsUrl = jenkinsUrl;
    }

    public String getJobBaseName() {
        return this.jobBaseName;
    }

    public void setJobBaseName(String jobBaseName) {
        this.jobBaseName = jobBaseName;
    }

    public String getJobDisplayUrl() {
        return this.jobDisplayUrl;
    }

    public void setJobDisplayUrl(String jobDisplayUrl) {
        this.jobDisplayUrl = jobDisplayUrl;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getJobUrl() {
        return this.jobUrl;
    }

    public void setJobUrl(String jobUrl) {
        this.jobUrl = jobUrl;
    }

    public String getGitUrl() {
        return this.gitUrl;
    }

    public void setGitUrl(String gitUrl) {
        this.gitUrl = gitUrl;
    }
}

