/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.KubernetesClient;
import io.fabric8.kubernetes.api.KubernetesFactory;
import io.fabric8.kubernetes.api.Watcher;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.watch.WatchEvent;
import java.io.IOException;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.UpgradeException;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWatcher<T extends HasMetadata>
implements Watcher<T> {
    private static final transient Logger LOG = LoggerFactory.getLogger(KubernetesClient.class);
    private ObjectMapper objectMapper;

    @OnWebSocketClose
    public void onClose(int statusCode, String reason) {
        LOG.debug("Connection closed: {} - {}", (Object)statusCode, (Object)reason);
        this.objectMapper = null;
    }

    @OnWebSocketConnect
    public void onConnect(Session session) {
        LOG.debug("Got connect: {}", (Object)session);
        this.objectMapper = KubernetesFactory.createObjectMapper();
    }

    @OnWebSocketMessage
    public void onMessage(String msg) {
        LOG.trace("Received message: {}", (Object)msg);
        if (msg != null && msg.length() > 0) {
            try {
                WatchEvent event = (WatchEvent)this.objectMapper.reader(WatchEvent.class).readValue(msg);
                HasMetadata obj = event.getObject();
                Watcher.Action action = Watcher.Action.valueOf(event.getType());
                this.eventReceived(action, obj);
            }
            catch (IOException e) {
                LOG.error("Could not deserialize watch event: {}", (Object)msg, (Object)e);
            }
            catch (ClassCastException e) {
                LOG.error("Received wrong type of object for watch", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                LOG.error("Invalid event type", (Throwable)e);
            }
        }
    }

    @OnWebSocketError
    public void onWebSocketError(Throwable cause) {
        if (cause instanceof UpgradeException) {
            LOG.error("WebSocketError: Could not upgrade connection: {}", (Object)((UpgradeException)cause).getResponseStatusCode(), (Object)cause);
        } else {
            LOG.error("WebSocketError: {}", cause);
        }
    }
}

