/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.support.KindToClassMapping;
import io.fabric8.utils.Objects;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserConfigurationCompare {
    private static final transient Logger LOG = LoggerFactory.getLogger(UserConfigurationCompare.class);
    protected static final Set<String> ignoredProperties = new HashSet<String>(Arrays.asList("status"));

    public static boolean configEqual(Object entity1, Object entity2) {
        Class<?> aClass;
        if (entity1 == entity2) {
            return true;
        }
        if (entity1 == null || entity2 == null) {
            return false;
        }
        if (entity1 instanceof Map) {
            return UserConfigurationCompare.configEqualMap((Map)entity1, UserConfigurationCompare.castTo(Map.class, entity2));
        }
        if (entity2 instanceof Map) {
            return UserConfigurationCompare.configEqualMap((Map)entity1, UserConfigurationCompare.castTo(Map.class, entity2));
        }
        if (entity2 instanceof ObjectMeta) {
            return UserConfigurationCompare.configEqualObjectMeta((ObjectMeta)entity1, UserConfigurationCompare.castTo(ObjectMeta.class, entity2));
        }
        HashSet classes = new HashSet(KindToClassMapping.getKindToClassMap().values());
        if (classes.contains(aClass = entity1.getClass())) {
            Object castEntity2 = UserConfigurationCompare.castTo(aClass, entity2);
            if (castEntity2 == null) {
                return false;
            }
            return UserConfigurationCompare.configEqualKubernetesDTO(entity1, entity2, aClass);
        }
        return Objects.equal((Object)entity1, (Object)entity2);
    }

    protected static boolean configEqualKubernetesDTO(@NotNull Object entity1, @NotNull Object entity2, @NotNull Class<?> clazz) {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            LOG.warn("Failed to get beanInfo for " + clazz.getName() + ". " + e, (Throwable)e);
            return false;
        }
        try {
            PropertyDescriptor[] propertyDescriptors;
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                Object value2;
                Object value1;
                Method readMethod;
                String name = propertyDescriptor.getName();
                if (ignoredProperties.contains(name) || (readMethod = propertyDescriptor.getReadMethod()) == null || UserConfigurationCompare.configEqual(value1 = UserConfigurationCompare.invokeMethod(entity1, readMethod), value2 = UserConfigurationCompare.invokeMethod(entity2, readMethod))) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected static Object invokeMethod(@NotNull Object entity, Method readMethod) throws InvocationTargetException, IllegalAccessException {
        try {
            return readMethod.invoke(entity, new Object[0]);
        }
        catch (Exception e) {
            LOG.warn("Failed to invoke method " + readMethod + " on " + entity + ". " + e, (Throwable)e);
            throw e;
        }
    }

    protected static boolean configEqualObjectMeta(ObjectMeta entity1, ObjectMeta entity2) {
        if (entity1 == entity2) {
            return true;
        }
        if (entity1 == null || entity2 == null) {
            return false;
        }
        return Objects.equal((Object)entity1.getName(), (Object)entity2.getName()) && Objects.equal((Object)entity1.getNamespace(), (Object)entity2.getNamespace()) && UserConfigurationCompare.configEqualMap(entity1.getLabels(), entity2.getLabels()) && UserConfigurationCompare.configEqualMap(entity1.getAnnotations(), entity2.getAnnotations());
    }

    protected static <T> T castTo(Class<T> clazz, Object entity) {
        if (clazz.isInstance(entity)) {
            return clazz.cast(entity);
        }
        if (entity != null) {
            LOG.warn("Invalid class " + entity.getClass().getName() + " when expecting " + clazz.getName() + " for instance: " + entity);
        }
        return null;
    }

    protected static boolean configEqualMap(Map entity1, Map entity2) {
        int size2;
        if (entity1 == entity2) {
            return true;
        }
        if (entity1 == null || entity2 == null) {
            return false;
        }
        int size1 = UserConfigurationCompare.size(entity1);
        if (size1 != (size2 = UserConfigurationCompare.size(entity2))) {
            return false;
        }
        Set entries = entity1.entrySet();
        for (Map.Entry entry : entries) {
            Object value2;
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (UserConfigurationCompare.configEqual(value, value2 = entity2.get(key))) continue;
            return false;
        }
        return true;
    }

    protected static boolean configEqualList(List v1, List v2) {
        int size2;
        int size1 = UserConfigurationCompare.size(v1);
        if (size1 != (size2 = UserConfigurationCompare.size(v2))) {
            return false;
        }
        int idx = 0;
        for (Object value : v1) {
            Object value2;
            if (UserConfigurationCompare.configEqual(value, value2 = v2.get(idx++))) continue;
            return false;
        }
        return true;
    }

    protected static int size(Map map) {
        return map == null ? 0 : map.size();
    }

    protected static int size(Collection coll) {
        return coll == null ? 0 : coll.size();
    }
}

