/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.builds;

import io.fabric8.openshift.api.model.Build;
import io.fabric8.utils.Objects;
import io.fabric8.utils.Strings;
import java.util.Collections;
import java.util.Map;

public class Builds {
    public static boolean isCompleted(String status) {
        return Objects.equal((Object)"Complete", (Object)status);
    }

    public static boolean isFailed(String status) {
        if (status != null) {
            return status.startsWith("Fail") || status.startsWith("Error");
        }
        return false;
    }

    public static boolean isFinished(String status) {
        return Builds.isCompleted(status) || Builds.isFailed(status);
    }

    public static String getUid(Build build) {
        String answer = null;
        if (build != null) {
            answer = build.getUid();
            if (Strings.isNullOrBlank((String)answer)) {
                Map<String, Object> metadata = Builds.getMetadata(build);
                answer = Builds.getString(metadata, "uid");
                if (Strings.isNullOrBlank((String)answer)) {
                    answer = Builds.getString(metadata, "id");
                }
                if (Strings.isNullOrBlank((String)answer)) {
                    answer = Builds.getString(metadata, "name");
                }
            }
            if (Strings.isNullOrBlank((String)answer)) {
                answer = build.getName();
            }
        }
        return answer;
    }

    protected static String getString(Map<String, Object> metadata, String name) {
        Object answer = metadata.get(name);
        if (answer != null) {
            return answer.toString();
        }
        return null;
    }

    public static Map<String, Object> getMetadata(Build build) {
        Object metadata;
        Map<String, Object> additionalProperties;
        if (build != null && (additionalProperties = build.getAdditionalProperties()) != null && (metadata = additionalProperties.get("metadata")) instanceof Map) {
            return (Map)metadata;
        }
        return Collections.EMPTY_MAP;
    }

    public static String getName(Build build) {
        Map<String, Object> metadata;
        String answer = null;
        if (build != null && Strings.isNullOrBlank((String)(answer = Builds.getString(metadata = Builds.getMetadata(build), "name")))) {
            answer = build.getName();
        }
        return answer;
    }

    public static String getBuildConfigName(Build build) {
        Map<String, Object> metadata;
        Object labels;
        if (build != null && (labels = (metadata = Builds.getMetadata(build)).get("labels")) instanceof Map) {
            Map labelMap = (Map)labels;
            return Builds.getString(labelMap, "buildconfig");
        }
        return null;
    }

    public static class Status {
        public static final String COMPLETE = "Complete";
        public static final String FAIL = "Fail";
        public static final String ERROR = "Error";
    }
}

