/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api;

import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigList;
import io.fabric8.openshift.api.model.BuildList;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigList;
import io.fabric8.openshift.api.model.ImageRepository;
import io.fabric8.openshift.api.model.ImageRepositoryList;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteList;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="osapi/v1beta1")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface KubernetesExtensions {
    @POST
    @Path(value="configs")
    @Consumes(value={"application/json"})
    public String createConfig(Object var1) throws Exception;

    @POST
    @Path(value="templateConfigs")
    @Consumes(value={"application/json"})
    public String createTemplateConfig(Object var1) throws Exception;

    @POST
    @Path(value="template")
    @Consumes(value={"application/json"})
    public String createTemplate(Object var1) throws Exception;

    @GET
    @Path(value="builds")
    public BuildList getBuilds(@QueryParam(value="namespace") String var1);

    @POST
    @Path(value="builds")
    public String createBuild(Build var1) throws Exception;

    @GET
    @Path(value="builds/{name}")
    public Build getBuild(@PathParam(value="name") @NotNull String var1, @QueryParam(value="namespace") String var2);

    @PUT
    @Path(value="builds/{name}")
    @Consumes(value={"application/json"})
    public String updateBuild(@PathParam(value="name") @NotNull String var1, Build var2, @QueryParam(value="namespace") String var3) throws Exception;

    @DELETE
    @Path(value="builds/{name}")
    public String deleteBuild(@PathParam(value="name") @NotNull String var1, @QueryParam(value="namespace") String var2);

    @GET
    @Path(value="buildConfigs")
    public BuildConfigList getBuildConfigs(@QueryParam(value="namespace") String var1);

    @POST
    @Path(value="buildConfigs")
    public String createBuildConfig(BuildConfig var1) throws Exception;

    @GET
    @Path(value="buildConfigs/{name}")
    public BuildConfig getBuildConfig(@PathParam(value="name") @NotNull String var1, @QueryParam(value="namespace") String var2);

    @PUT
    @Path(value="buildConfigs/{name}")
    @Consumes(value={"application/json"})
    public String updateBuildConfig(@PathParam(value="name") @NotNull String var1, BuildConfig var2, @QueryParam(value="namespace") String var3) throws Exception;

    @DELETE
    @Path(value="buildConfigs/{name}")
    public String deleteBuildConfig(@PathParam(value="name") @NotNull String var1, @QueryParam(value="namespace") String var2);

    @POST
    @Path(value="buildConfigHooks/{name}/{secret}/{type}")
    public String triggerBuild(@PathParam(value="name") @NotNull String var1, @QueryParam(value="namespace") String var2, @PathParam(value="secret") @NotNull String var3, @PathParam(value="type") @NotNull String var4, Object var5);

    @GET
    @Path(value="imageRepositories")
    public ImageRepositoryList getImageRepositories(@QueryParam(value="namespace") String var1);

    @POST
    @Path(value="imageRepositories")
    public String createImageRepository(ImageRepository var1) throws Exception;

    @GET
    @Path(value="imageRepositories/{name}")
    public ImageRepository getImageRepository(@PathParam(value="name") @NotNull String var1, @QueryParam(value="namespace") String var2);

    @PUT
    @Path(value="imageRepositories/{name}")
    @Consumes(value={"application/json"})
    public String updateImageRepository(@PathParam(value="name") @NotNull String var1, ImageRepository var2, @QueryParam(value="namespace") String var3) throws Exception;

    @DELETE
    @Path(value="imageRepositories/{name}")
    public String deleteImageRepository(@PathParam(value="name") @NotNull String var1, @QueryParam(value="namespace") String var2);

    @GET
    @Path(value="deploymentConfigs")
    public DeploymentConfigList getDeploymentConfigs(@QueryParam(value="namespace") String var1);

    @POST
    @Path(value="deploymentConfigs")
    public String createDeploymentConfig(DeploymentConfig var1) throws Exception;

    @GET
    @Path(value="deploymentConfigs/{name}")
    public DeploymentConfig getDeploymentConfig(@PathParam(value="name") @NotNull String var1, @QueryParam(value="namespace") String var2);

    @PUT
    @Path(value="deploymentConfigs/{name}")
    @Consumes(value={"application/json"})
    public String updateDeploymentConfig(@PathParam(value="name") @NotNull String var1, DeploymentConfig var2, @QueryParam(value="namespace") String var3) throws Exception;

    @DELETE
    @Path(value="deploymentConfigs/{name}")
    public String deleteDeploymentConfig(@PathParam(value="name") @NotNull String var1, @QueryParam(value="namespace") String var2);

    @GET
    @Path(value="routes")
    public RouteList getRoutes(@QueryParam(value="namespace") String var1);

    @GET
    @Path(value="routes/{name}")
    public Route getRoute(@PathParam(value="name") @NotNull String var1, @QueryParam(value="namespace") String var2);
}

