/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api;

import com.fasterxml.jackson.databind.JsonNode;
import io.fabric8.kubernetes.api.Config;
import io.fabric8.kubernetes.api.Entity;
import io.fabric8.kubernetes.api.KubernetesClient;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.utils.Files;
import io.fabric8.utils.Objects;
import io.fabric8.utils.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class Controller {
    private static final transient Logger LOG = LoggerFactory.getLogger(Controller.class);
    private final KubernetesClient kubernetes;
    private Map<String, Pod> podMap = null;
    private Map<String, ReplicationController> replicationControllerMap = null;
    private Map<String, Service> serviceMap = null;

    public Controller() {
        this(new KubernetesClient());
    }

    public Controller(KubernetesClient kubernetes) {
        this.kubernetes = kubernetes;
    }

    public String apply(File file) throws IOException {
        String ext = Files.getFileExtension((File)file);
        if ("yaml".equalsIgnoreCase(ext)) {
            return this.applyYaml(file);
        }
        if ("json".equalsIgnoreCase(ext)) {
            return this.applyJson(file);
        }
        throw new IllegalArgumentException("Unknown file type " + ext);
    }

    public String applyJson(byte[] json) throws IOException {
        Object dto = KubernetesHelper.loadJson(json);
        this.apply(dto, "REST call");
        return "";
    }

    public String applyJson(String json) throws IOException {
        Object dto = KubernetesHelper.loadJson(json);
        this.apply(dto, "REST call");
        return "";
    }

    public String applyJson(File json) throws IOException {
        Object dto = KubernetesHelper.loadJson(json);
        this.apply(dto, "REST call");
        return "";
    }

    public String applyYaml(String yaml) throws IOException {
        String json = this.convertYamlToJson(yaml);
        Object dto = KubernetesHelper.loadJson(json);
        this.apply(dto, "REST call");
        return "";
    }

    public String applyYaml(File yaml) throws IOException {
        String json = this.convertYamlToJson(yaml);
        Object dto = KubernetesHelper.loadJson(json);
        this.apply(dto, "REST call");
        return "";
    }

    private String convertYamlToJson(String yamlString) throws FileNotFoundException {
        Yaml yaml = new Yaml();
        FileInputStream fstream = new FileInputStream(yamlString);
        Map map = (Map)yaml.load((InputStream)fstream);
        JSONObject jsonObject = new JSONObject(map);
        return jsonObject.toString();
    }

    private String convertYamlToJson(File yamlFile) throws FileNotFoundException {
        Yaml yaml = new Yaml();
        FileInputStream fstream = new FileInputStream(yamlFile);
        Map map = (Map)yaml.load((InputStream)fstream);
        JSONObject jsonObject = new JSONObject(map);
        return jsonObject.toString();
    }

    public String applyJson(InputStream json) throws IOException {
        Object dto = KubernetesHelper.loadJson(json);
        this.apply(dto, "REST call");
        return "";
    }

    public void apply(Object dto, String sourceName) throws IOException {
        if (dto instanceof Config) {
            this.applyConfig((Config)dto, sourceName);
        } else if (dto instanceof Entity) {
            this.applyEntity((Entity)dto, sourceName);
        } else if (dto instanceof JsonNode) {
            JsonNode tree = (JsonNode)dto;
            JsonNode kindNode = tree.get("kind");
            if (kindNode != null) {
                String kind = kindNode.asText();
                if (Objects.equal((Object)"Config", (Object)kind)) {
                    this.applyConfig(tree, sourceName);
                } else if (Objects.equal((Object)"Template", (Object)kind)) {
                    this.applyTemplateConfig(tree, sourceName);
                } else {
                    LOG.warn("Unknown JSON type " + kindNode + ". JSON: " + tree);
                }
            } else {
                LOG.warn("No JSON kind for: " + tree);
            }
        } else {
            LOG.warn("Unknown Kublelet from " + sourceName + ". Object: " + dto);
        }
    }

    public void applyEntity(Object dto, String sourceName) {
        if (dto instanceof Pod) {
            this.applyPod((Pod)dto, sourceName);
        } else if (dto instanceof ReplicationController) {
            this.applyReplicationController((ReplicationController)dto, sourceName);
        } else if (dto instanceof Service) {
            this.applyService((Service)dto, sourceName);
        } else {
            throw new IllegalArgumentException("Unknown entity type " + dto);
        }
    }

    public void applyTemplateConfig(JsonNode entity, String sourceName) {
        try {
            this.kubernetes.createTemplate(entity);
        }
        catch (Exception e) {
            LOG.error("Failed to create controller from " + sourceName + ". " + e, (Throwable)e);
        }
    }

    public void applyConfig(Config config, String sourceName) throws IOException {
        List<Object> entities = KubernetesHelper.getEntities(config);
        for (Object entity : entities) {
            this.applyEntity(entity, sourceName);
        }
    }

    public void applyConfig(JsonNode entity, String sourceName) throws IOException {
        JsonNode items = entity.get("items");
        if (items != null) {
            for (JsonNode item : items) {
                String json = item.toString();
                LOG.debug("Got item: {}", (Object)json);
                Object dto = null;
                try {
                    dto = KubernetesHelper.loadJson(json);
                }
                catch (IOException e) {
                    LOG.error("Failed to process " + json + ". " + e, (Throwable)e);
                }
                if (dto == null) continue;
                this.apply(dto, sourceName);
            }
        }
    }

    public void applyService(Service serviceSchema, String sourceName) {
        String id;
        Service old;
        String namespace = this.getNamespace();
        if (this.serviceMap == null) {
            this.serviceMap = KubernetesHelper.getServiceMap(this.kubernetes, namespace);
        }
        if (this.isRunning(old = this.serviceMap.get(id = KubernetesHelper.getId(serviceSchema)))) {
            LOG.info("Updating a service from " + sourceName);
            try {
                String answer = this.kubernetes.updateService(id, serviceSchema, namespace);
                LOG.info("Updated service: " + answer);
            }
            catch (Exception e) {
                LOG.error("Failed to update controller from " + sourceName + ". " + e + ". " + serviceSchema, (Throwable)e);
            }
        } else {
            LOG.info("Creating a service from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getId(serviceSchema));
            try {
                String answer = Strings.isNotBlank((String)namespace) ? this.kubernetes.createService(serviceSchema, namespace) : this.kubernetes.createService(serviceSchema);
                LOG.info("Created service: " + answer);
            }
            catch (Exception e) {
                LOG.error("Failed to create service from " + sourceName + ". " + e + ". " + serviceSchema, (Throwable)e);
            }
        }
    }

    public void applyReplicationController(ReplicationController replicationController, String sourceName) {
        String id;
        ReplicationController old;
        String namespace = this.getNamespace();
        if (this.replicationControllerMap == null) {
            this.replicationControllerMap = KubernetesHelper.getReplicationControllerMap(this.kubernetes, namespace);
        }
        if (this.isRunning(old = this.replicationControllerMap.get(id = KubernetesHelper.getId(replicationController)))) {
            LOG.info("Updating replicationController from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getId(replicationController));
            try {
                String answer = this.kubernetes.updateReplicationController(id, replicationController);
                LOG.info("Updated replicationController: " + answer);
            }
            catch (Exception e) {
                LOG.error("Failed to update replicationController from " + sourceName + ". " + e + ". " + replicationController, (Throwable)e);
            }
        } else {
            LOG.info("Creating a replicationController from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getId(replicationController));
            try {
                String answer = Strings.isNotBlank((String)namespace) ? this.kubernetes.createReplicationController(replicationController, namespace) : this.kubernetes.createReplicationController(replicationController);
                LOG.info("Created replicationController: " + answer);
            }
            catch (Exception e) {
                LOG.error("Failed to create replicationController from " + sourceName + ". " + e + ". " + replicationController, (Throwable)e);
            }
        }
    }

    public void applyPod(Pod pod, String sourceName) {
        String id;
        Pod old;
        String namespace = this.getNamespace();
        if (this.podMap == null) {
            this.podMap = KubernetesHelper.getPodMap(this.kubernetes, namespace);
        }
        if (this.isRunning(old = this.podMap.get(id = KubernetesHelper.getId(pod)))) {
            LOG.info("Updating a pod from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getId(pod));
            try {
                String answer = this.kubernetes.updatePod(id, pod);
                LOG.info("Updated pod result: " + answer);
            }
            catch (Exception e) {
                LOG.error("Failed to update pod from " + sourceName + ". " + e + ". " + pod, (Throwable)e);
            }
        } else {
            LOG.info("Creating a pod from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getId(pod));
            try {
                String answer = Strings.isNotBlank((String)namespace) ? this.kubernetes.createPod(pod, namespace) : this.kubernetes.createPod(pod);
                LOG.info("Created pod result: " + answer);
            }
            catch (Exception e) {
                LOG.error("Failed to create pod from " + sourceName + ". " + e + ". " + pod, (Throwable)e);
            }
        }
    }

    public String getNamespace() {
        return this.kubernetes.getNamespace();
    }

    public void setNamespace(String namespace) {
        this.kubernetes.setNamespace(namespace);
    }

    protected boolean isRunning(Pod entity) {
        return entity != null;
    }

    protected boolean isRunning(ReplicationController entity) {
        return entity != null;
    }

    protected boolean isRunning(Service entity) {
        return entity != null;
    }
}

