/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.cfg.Annotations;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import io.fabric8.kubernetes.api.ExceptionResponseMapper;
import io.fabric8.kubernetes.api.Kubernetes;
import io.fabric8.kubernetes.api.KubernetesExtensions;
import io.fabric8.utils.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.transport.http.HTTPConduit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesFactory {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String DEFAULT_KUBERNETES_MASTER = "http://localhost:8080";
    public static final String KUBERNETES_TRUST_ALL_CERIFICATES = "KUBERNETES_TRUST_CERT";
    public static final String KUBERNETES_USERNAME = "KUBERNETES_USERNAME";
    public static final String KUBERNETES_PASSWORD = "KUBERNETES_PASSWORD";
    public static final String KUBERNETES_SERVICE_HOST_ENV_VAR = "KUBERNETES_SERVICE_HOST";
    public static final String KUBERNETES_SERVICE_PORT_ENV_VAR = "KUBERNETES_SERVICE_PORT";
    public static final String KUBERNETES_RO_SERVICE_HOST_ENV_VAR = "KUBERNETES_RO_SERVICE_HOST";
    public static final String KUBERNETES_RO_SERVICE_PORT_ENV_VAR = "KUBERNETES_RO_SERVICE_PORT";
    public static final String KUBERNETES_MASTER_ENV_VAR = "KUBERNETES_MASTER";
    public static final String KUBERNETES_MASTER_SYSTEM_PROPERTY = "kubernetes.master";
    private String address;
    private boolean trustAllCerts = false;
    private String username;
    private String password;

    public KubernetesFactory() {
        this(null);
    }

    public KubernetesFactory(boolean writeable) {
        this(null, writeable);
    }

    public KubernetesFactory(String address) {
        this(address, false);
    }

    public KubernetesFactory(String address, boolean writeable) {
        if (Strings.isNullOrBlank((String)address)) {
            this.setAddress(this.findKubernetesMaster(writeable));
        } else {
            this.setAddress(address);
        }
        this.init();
    }

    protected String findKubernetesMaster() {
        return this.findKubernetesMaster(false);
    }

    protected String findKubernetesMaster(boolean writeable) {
        return KubernetesFactory.resolveHttpKubernetesMaster(writeable);
    }

    private void init() {
        if (System.getenv(KUBERNETES_TRUST_ALL_CERIFICATES) != null) {
            this.trustAllCerts = Boolean.valueOf(System.getenv(KUBERNETES_TRUST_ALL_CERIFICATES));
        }
        if (System.getenv(KUBERNETES_USERNAME) != null) {
            this.username = System.getenv(KUBERNETES_USERNAME);
        }
        if (System.getenv(KUBERNETES_PASSWORD) != null) {
            this.password = System.getenv(KUBERNETES_PASSWORD);
        }
    }

    public String toString() {
        return "KubernetesFactory{" + this.address + '}';
    }

    public Kubernetes createKubernetes() {
        return this.createWebClient(Kubernetes.class);
    }

    public KubernetesExtensions createKubernetesExtensions() {
        return this.createWebClient(KubernetesExtensions.class);
    }

    public <T> T createWebClient(Class<T> clientType) {
        List<Object> providers = this.createProviders();
        WebClient webClient = WebClient.create((String)this.address, providers);
        this.configureAuthDetails(webClient);
        if (this.trustAllCerts) {
            this.disableSslChecks(webClient);
        }
        return (T)JAXRSClientFactory.fromClient((Client)webClient, clientType);
    }

    protected List<Object> createProviders() {
        ArrayList<Object> providers = new ArrayList<Object>();
        Annotations[] annotationsToUse = JacksonJaxbJsonProvider.DEFAULT_ANNOTATIONS;
        ObjectMapper objectMapper = KubernetesFactory.createObjectMapper();
        providers.add(new JacksonJaxbJsonProvider(objectMapper, annotationsToUse));
        providers.add((Object)new PlainTextJacksonProvider(objectMapper, annotationsToUse));
        providers.add(new ExceptionResponseMapper());
        return providers;
    }

    public String getKubernetesMaster() {
        String answer = this.address;
        int idx = answer.lastIndexOf(":");
        if (idx > 0) {
            answer = answer.substring(0, idx);
        }
        if ((idx = answer.lastIndexOf(":")) > 0) {
            answer = answer.substring(idx + 1);
        }
        if ((idx = answer.lastIndexOf("/")) > 0) {
            answer = answer.substring(idx + 1);
        }
        return answer;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
        if (Strings.isNullOrBlank((String)address)) {
            this.findKubernetesMaster();
        }
        try {
            this.validateKubernetesMaster();
        }
        catch (SSLHandshakeException e) {
            this.log.error("SSL handshake failed - this probably means that you need to trust the kubernetes SSL certificate or set the environment variable KUBERNETES_TRUST_CERT", (Throwable)e);
            throw new IllegalArgumentException("Invalid kubernetes master address: " + address, e);
        }
        catch (SSLProtocolException e) {
            this.log.error("SSL protocol error", (Throwable)e);
            throw new IllegalArgumentException("Invalid kubernetes master address: " + address, e);
        }
        catch (SSLKeyException e) {
            this.log.error("Bad SSL key", (Throwable)e);
            throw new IllegalArgumentException("Invalid kubernetes master address: " + address, e);
        }
        catch (SSLPeerUnverifiedException e) {
            this.log.error("Could not verify server", (Throwable)e);
            throw new IllegalArgumentException("Invalid kubernetes master address: " + address, e);
        }
        catch (SSLException e) {
            this.log.warn("Address does not appear to be SSL-enabled - falling back to http", (Throwable)e);
            this.setAddress(address.replaceFirst("https", "http"));
        }
        catch (IOException e) {
            this.log.warn("Failed to validate kubernetes master address", (Throwable)e);
            throw new IllegalArgumentException("Invalid kubernetes master address: " + address, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateKubernetesMaster() throws IOException {
        URL url = new URL(this.address);
        switch (url.getProtocol()) {
            case "http": {
                URLConnection connection = url.openConnection();
                connection.connect();
                break;
            }
            case "https": {
                SSLSocketFactory sslsocketfactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
                try (SSLSocket sslsocket = (SSLSocket)sslsocketfactory.createSocket(url.getHost(), url.getPort());){
                    InputStream in = sslsocket.getInputStream();
                    OutputStream out = sslsocket.getOutputStream();
                    out.write(1);
                    while (in.available() > 0) {
                        System.out.print(in.read());
                    }
                    break;
                }
            }
        }
    }

    public static String resolveHttpKubernetesMaster() {
        return KubernetesFactory.resolveHttpKubernetesMaster(false);
    }

    public static String resolveHttpKubernetesMaster(boolean writeable) {
        String kubernetesMaster = KubernetesFactory.resolveKubernetesMaster(writeable);
        if (kubernetesMaster.startsWith("tcp:")) {
            return "http:" + kubernetesMaster.substring(4);
        }
        return kubernetesMaster;
    }

    public static String resolveKubernetesMaster() {
        return KubernetesFactory.resolveKubernetesMaster(false);
    }

    public static String resolveKubernetesMaster(boolean writeable) {
        String kubernetesMaster;
        String hostEnvVar = KUBERNETES_RO_SERVICE_HOST_ENV_VAR;
        String portEnvVar = KUBERNETES_RO_SERVICE_PORT_ENV_VAR;
        String proto = "http";
        if (writeable) {
            hostEnvVar = KUBERNETES_SERVICE_HOST_ENV_VAR;
            portEnvVar = KUBERNETES_SERVICE_PORT_ENV_VAR;
            proto = "https";
        }
        if (Strings.isNullOrBlank((String)(kubernetesMaster = Strings.isNotBlank((String)(kubernetesMaster = System.getenv(hostEnvVar))) ? proto + "://" + kubernetesMaster + ":" + System.getenv(portEnvVar) : System.getenv(KUBERNETES_MASTER_ENV_VAR)))) {
            kubernetesMaster = System.getProperty(KUBERNETES_MASTER_SYSTEM_PROPERTY);
        }
        if (Strings.isNotBlank((String)kubernetesMaster)) {
            return kubernetesMaster;
        }
        return DEFAULT_KUBERNETES_MASTER;
    }

    public static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        return mapper;
    }

    private void configureAuthDetails(WebClient webClient) {
        if (Strings.isNotBlank((String)this.username) && Strings.isNotBlank((String)this.password)) {
            HTTPConduit conduit = WebClient.getConfig((Object)webClient).getHttpConduit();
            conduit.getAuthorization().setUserName(this.username);
            conduit.getAuthorization().setPassword(this.password);
        }
    }

    private void disableSslChecks(WebClient webClient) {
        HTTPConduit conduit = WebClient.getConfig((Object)webClient).getHttpConduit();
        TLSClientParameters params = conduit.getTlsClientParameters();
        if (params == null) {
            params = new TLSClientParameters();
            conduit.setTlsClientParameters(params);
        }
        params.setTrustManagers(new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }});
        params.setDisableCNCheck(true);
    }

    @Provider
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public static class PlainTextJacksonProvider
    extends JacksonJaxbJsonProvider {
        public PlainTextJacksonProvider(ObjectMapper mapper, Annotations[] annotationsToUse) {
            super(mapper, annotationsToUse);
        }

        protected boolean hasMatchingMediaType(MediaType mediaType) {
            boolean answer = super.hasMatchingMediaType(mediaType);
            String type = mediaType.getType();
            String subtype = mediaType.getSubtype();
            if (!answer && type.equals("text")) {
                answer = super.hasMatchingMediaType(MediaType.APPLICATION_JSON_TYPE);
            }
            return answer;
        }
    }
}

