/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.mbeans;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.mbeans.AppViewDetails;
import io.fabric8.kubernetes.api.mbeans.NamespaceAndAppPath;
import io.fabric8.kubernetes.api.model.PodSchema;
import io.fabric8.kubernetes.api.model.ReplicationControllerSchema;
import io.fabric8.kubernetes.api.model.ServiceSchema;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AppViewSnapshot {
    private final Map<NamespaceAndAppPath, AppViewDetails> apps = new HashMap<NamespaceAndAppPath, AppViewDetails>();
    private final Map<String, ServiceSchema> servicesMap;
    private final Map<String, ReplicationControllerSchema> controllerMap;
    private final Map<String, PodSchema> podMap;

    public AppViewSnapshot(Map<String, ServiceSchema> servicesMap, Map<String, ReplicationControllerSchema> controllerMap, Map<String, PodSchema> podMap) {
        this.servicesMap = servicesMap;
        this.controllerMap = controllerMap;
        this.podMap = podMap;
    }

    public AppViewDetails getOrCreateAppView(String appPath, String namespace) {
        NamespaceAndAppPath key = new NamespaceAndAppPath(namespace, appPath);
        AppViewDetails answer = this.apps.get(key);
        if (answer == null) {
            answer = new AppViewDetails(this, appPath, namespace);
            this.apps.put(key, answer);
        }
        return answer;
    }

    public Map<NamespaceAndAppPath, AppViewDetails> getApps() {
        return this.apps;
    }

    public Map<String, ReplicationControllerSchema> getControllerMap() {
        return this.controllerMap;
    }

    public Map<String, PodSchema> getPodMap() {
        return this.podMap;
    }

    public Map<String, ServiceSchema> getServicesMap() {
        return this.servicesMap;
    }

    public List<PodSchema> podsForReplicationController(ReplicationControllerSchema controller) {
        return KubernetesHelper.getPodsForReplicationController(controller, this.podMap.values());
    }
}

