/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api;

import io.fabric8.kubernetes.api.Controller;
import io.fabric8.kubernetes.api.KubernetesClient;
import io.fabric8.kubernetes.api.KubernetesManagerMXBean;
import io.fabric8.utils.JMXUtils;
import io.fabric8.utils.Strings;
import java.io.IOException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class KubernetesManager
implements KubernetesManagerMXBean {
    public static ObjectName OBJECT_NAME;
    private KubernetesClient kubernetes = new KubernetesClient();

    public void init() {
        JMXUtils.registerMBean((Object)this, (ObjectName)OBJECT_NAME);
    }

    public void destroy() {
        JMXUtils.unregisterMBean((ObjectName)OBJECT_NAME);
    }

    @Override
    public String apply(String json) throws IOException {
        Controller controller = new Controller(this.kubernetes);
        return controller.applyJson(json);
    }

    @Override
    public String getDockerRegistry() {
        String answer = System.getenv("DOCKER_REGISTRY");
        if (Strings.isNotBlank((String)answer) && !answer.contains("://")) {
            answer = "http://" + answer;
        }
        return answer;
    }

    public KubernetesClient getKubernetes() {
        return this.kubernetes;
    }

    public void setKubernetes(KubernetesClient kubernetes) {
        this.kubernetes = kubernetes;
    }

    static {
        try {
            OBJECT_NAME = new ObjectName("io.fabric8:type=KubernetesManager");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
    }
}

