/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.bindings.v1beta1;

import io.fabric8.knative.bindings.v1beta1.KafkaAuthSpec;
import io.fabric8.knative.bindings.v1beta1.KafkaNetSpec;
import io.fabric8.knative.bindings.v1beta1.KafkaNetSpecBuilder;
import io.fabric8.knative.bindings.v1beta1.KafkaNetSpecFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class KafkaAuthSpecFluent<A extends KafkaAuthSpecFluent<A>>
extends BaseFluent<A> {
    private List<String> bootstrapServers = new ArrayList<String>();
    private KafkaNetSpecBuilder net;
    private Map<String, Object> additionalProperties;

    public KafkaAuthSpecFluent() {
    }

    public KafkaAuthSpecFluent(KafkaAuthSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(KafkaAuthSpec instance) {
        KafkaAuthSpec kafkaAuthSpec = instance = instance != null ? instance : new KafkaAuthSpec();
        if (instance != null) {
            this.withBootstrapServers(instance.getBootstrapServers());
            this.withNet(instance.getNet());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToBootstrapServers(int index, String item) {
        if (this.bootstrapServers == null) {
            this.bootstrapServers = new ArrayList<String>();
        }
        this.bootstrapServers.add(index, item);
        return (A)((Object)this);
    }

    public A setToBootstrapServers(int index, String item) {
        if (this.bootstrapServers == null) {
            this.bootstrapServers = new ArrayList<String>();
        }
        this.bootstrapServers.set(index, item);
        return (A)((Object)this);
    }

    public A addToBootstrapServers(String ... items) {
        if (this.bootstrapServers == null) {
            this.bootstrapServers = new ArrayList<String>();
        }
        for (String item : items) {
            this.bootstrapServers.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToBootstrapServers(Collection<String> items) {
        if (this.bootstrapServers == null) {
            this.bootstrapServers = new ArrayList<String>();
        }
        for (String item : items) {
            this.bootstrapServers.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromBootstrapServers(String ... items) {
        if (this.bootstrapServers == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.bootstrapServers.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromBootstrapServers(Collection<String> items) {
        if (this.bootstrapServers == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.bootstrapServers.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getBootstrapServers() {
        return this.bootstrapServers;
    }

    public String getBootstrapServer(int index) {
        return this.bootstrapServers.get(index);
    }

    public String getFirstBootstrapServer() {
        return this.bootstrapServers.get(0);
    }

    public String getLastBootstrapServer() {
        return this.bootstrapServers.get(this.bootstrapServers.size() - 1);
    }

    public String getMatchingBootstrapServer(Predicate<String> predicate) {
        for (String item : this.bootstrapServers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingBootstrapServer(Predicate<String> predicate) {
        for (String item : this.bootstrapServers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withBootstrapServers(List<String> bootstrapServers) {
        if (bootstrapServers != null) {
            this.bootstrapServers = new ArrayList<String>();
            for (String item : bootstrapServers) {
                this.addToBootstrapServers(item);
            }
        } else {
            this.bootstrapServers = null;
        }
        return (A)((Object)this);
    }

    public A withBootstrapServers(String ... bootstrapServers) {
        if (this.bootstrapServers != null) {
            this.bootstrapServers.clear();
            this._visitables.remove((Object)"bootstrapServers");
        }
        if (bootstrapServers != null) {
            for (String item : bootstrapServers) {
                this.addToBootstrapServers(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasBootstrapServers() {
        return this.bootstrapServers != null && !this.bootstrapServers.isEmpty();
    }

    public KafkaNetSpec buildNet() {
        return this.net != null ? this.net.build() : null;
    }

    public A withNet(KafkaNetSpec net) {
        this._visitables.remove((Object)"net");
        if (net != null) {
            this.net = new KafkaNetSpecBuilder(net);
            this._visitables.get((Object)"net").add(this.net);
        } else {
            this.net = null;
            this._visitables.get((Object)"net").remove((Object)this.net);
        }
        return (A)((Object)this);
    }

    public boolean hasNet() {
        return this.net != null;
    }

    public NetNested<A> withNewNet() {
        return new NetNested(null);
    }

    public NetNested<A> withNewNetLike(KafkaNetSpec item) {
        return new NetNested(item);
    }

    public NetNested<A> editNet() {
        return this.withNewNetLike(Optional.ofNullable(this.buildNet()).orElse(null));
    }

    public NetNested<A> editOrNewNet() {
        return this.withNewNetLike(Optional.ofNullable(this.buildNet()).orElse(new KafkaNetSpecBuilder().build()));
    }

    public NetNested<A> editOrNewNetLike(KafkaNetSpec item) {
        return this.withNewNetLike(Optional.ofNullable(this.buildNet()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaAuthSpecFluent that = (KafkaAuthSpecFluent)((Object)o);
        if (!Objects.equals(this.bootstrapServers, that.bootstrapServers)) {
            return false;
        }
        if (!Objects.equals((Object)this.net, (Object)that.net)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bootstrapServers, this.net, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bootstrapServers != null && !this.bootstrapServers.isEmpty()) {
            sb.append("bootstrapServers:");
            sb.append(String.valueOf(this.bootstrapServers) + ",");
        }
        if (this.net != null) {
            sb.append("net:");
            sb.append(String.valueOf((Object)this.net) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class NetNested<N>
    extends KafkaNetSpecFluent<NetNested<N>>
    implements Nested<N> {
        KafkaNetSpecBuilder builder;

        NetNested(KafkaNetSpec item) {
            this.builder = new KafkaNetSpecBuilder(this, item);
        }

        public N and() {
            return (N)KafkaAuthSpecFluent.this.withNet(this.builder.build());
        }

        public N endNet() {
            return this.and();
        }
    }
}

