/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.duck.v1alpha1;

import io.fabric8.knative.duck.v1alpha1.Placeable;
import io.fabric8.knative.duck.v1alpha1.Placement;
import io.fabric8.knative.duck.v1alpha1.PlacementBuilder;
import io.fabric8.knative.duck.v1alpha1.PlacementFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class PlaceableFluent<A extends PlaceableFluent<A>>
extends BaseFluent<A> {
    private Integer maxAllowedVReplicas;
    private ArrayList<PlacementBuilder> placements = new ArrayList();
    private Map<String, Object> additionalProperties;

    public PlaceableFluent() {
    }

    public PlaceableFluent(Placeable instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Placeable instance) {
        Placeable placeable = instance = instance != null ? instance : new Placeable();
        if (instance != null) {
            this.withMaxAllowedVReplicas(instance.getMaxAllowedVReplicas());
            this.withPlacements(instance.getPlacements());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Integer getMaxAllowedVReplicas() {
        return this.maxAllowedVReplicas;
    }

    public A withMaxAllowedVReplicas(Integer maxAllowedVReplicas) {
        this.maxAllowedVReplicas = maxAllowedVReplicas;
        return (A)((Object)this);
    }

    public boolean hasMaxAllowedVReplicas() {
        return this.maxAllowedVReplicas != null;
    }

    public A addToPlacements(int index, Placement item) {
        if (this.placements == null) {
            this.placements = new ArrayList();
        }
        PlacementBuilder builder = new PlacementBuilder(item);
        if (index < 0 || index >= this.placements.size()) {
            this._visitables.get((Object)"placements").add(builder);
            this.placements.add(builder);
        } else {
            this._visitables.get((Object)"placements").add(index, builder);
            this.placements.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToPlacements(int index, Placement item) {
        if (this.placements == null) {
            this.placements = new ArrayList();
        }
        PlacementBuilder builder = new PlacementBuilder(item);
        if (index < 0 || index >= this.placements.size()) {
            this._visitables.get((Object)"placements").add(builder);
            this.placements.add(builder);
        } else {
            this._visitables.get((Object)"placements").set(index, builder);
            this.placements.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToPlacements(Placement ... items) {
        if (this.placements == null) {
            this.placements = new ArrayList();
        }
        for (Placement item : items) {
            PlacementBuilder builder = new PlacementBuilder(item);
            this._visitables.get((Object)"placements").add(builder);
            this.placements.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToPlacements(Collection<Placement> items) {
        if (this.placements == null) {
            this.placements = new ArrayList();
        }
        for (Placement item : items) {
            PlacementBuilder builder = new PlacementBuilder(item);
            this._visitables.get((Object)"placements").add(builder);
            this.placements.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromPlacements(Placement ... items) {
        if (this.placements == null) {
            return (A)((Object)this);
        }
        for (Placement item : items) {
            PlacementBuilder builder = new PlacementBuilder(item);
            this._visitables.get((Object)"placements").remove((Object)builder);
            this.placements.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPlacements(Collection<Placement> items) {
        if (this.placements == null) {
            return (A)((Object)this);
        }
        for (Placement item : items) {
            PlacementBuilder builder = new PlacementBuilder(item);
            this._visitables.get((Object)"placements").remove((Object)builder);
            this.placements.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromPlacements(Predicate<PlacementBuilder> predicate) {
        if (this.placements == null) {
            return (A)((Object)this);
        }
        Iterator<PlacementBuilder> each = this.placements.iterator();
        List visitables = this._visitables.get((Object)"placements");
        while (each.hasNext()) {
            PlacementBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Placement> buildPlacements() {
        return this.placements != null ? PlaceableFluent.build(this.placements) : null;
    }

    public Placement buildPlacement(int index) {
        return this.placements.get(index).build();
    }

    public Placement buildFirstPlacement() {
        return this.placements.get(0).build();
    }

    public Placement buildLastPlacement() {
        return this.placements.get(this.placements.size() - 1).build();
    }

    public Placement buildMatchingPlacement(Predicate<PlacementBuilder> predicate) {
        for (PlacementBuilder item : this.placements) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPlacement(Predicate<PlacementBuilder> predicate) {
        for (PlacementBuilder item : this.placements) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPlacements(List<Placement> placements) {
        if (this.placements != null) {
            this._visitables.get((Object)"placements").clear();
        }
        if (placements != null) {
            this.placements = new ArrayList();
            for (Placement item : placements) {
                this.addToPlacements(item);
            }
        } else {
            this.placements = null;
        }
        return (A)((Object)this);
    }

    public A withPlacements(Placement ... placements) {
        if (this.placements != null) {
            this.placements.clear();
            this._visitables.remove((Object)"placements");
        }
        if (placements != null) {
            for (Placement item : placements) {
                this.addToPlacements(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasPlacements() {
        return this.placements != null && !this.placements.isEmpty();
    }

    public A addNewPlacement(String podName, Integer vreplicas) {
        return this.addToPlacements(new Placement(podName, vreplicas));
    }

    public PlacementsNested<A> addNewPlacement() {
        return new PlacementsNested(-1, null);
    }

    public PlacementsNested<A> addNewPlacementLike(Placement item) {
        return new PlacementsNested(-1, item);
    }

    public PlacementsNested<A> setNewPlacementLike(int index, Placement item) {
        return new PlacementsNested(index, item);
    }

    public PlacementsNested<A> editPlacement(int index) {
        if (this.placements.size() <= index) {
            throw new RuntimeException("Can't edit placements. Index exceeds size.");
        }
        return this.setNewPlacementLike(index, this.buildPlacement(index));
    }

    public PlacementsNested<A> editFirstPlacement() {
        if (this.placements.size() == 0) {
            throw new RuntimeException("Can't edit first placements. The list is empty.");
        }
        return this.setNewPlacementLike(0, this.buildPlacement(0));
    }

    public PlacementsNested<A> editLastPlacement() {
        int index = this.placements.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last placements. The list is empty.");
        }
        return this.setNewPlacementLike(index, this.buildPlacement(index));
    }

    public PlacementsNested<A> editMatchingPlacement(Predicate<PlacementBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.placements.size(); ++i) {
            if (!predicate.test(this.placements.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching placements. No match found.");
        }
        return this.setNewPlacementLike(index, this.buildPlacement(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PlaceableFluent that = (PlaceableFluent)((Object)o);
        if (!Objects.equals(this.maxAllowedVReplicas, that.maxAllowedVReplicas)) {
            return false;
        }
        if (!Objects.equals(this.placements, that.placements)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.maxAllowedVReplicas, this.placements, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.maxAllowedVReplicas != null) {
            sb.append("maxAllowedVReplicas:");
            sb.append(this.maxAllowedVReplicas + ",");
        }
        if (this.placements != null && !this.placements.isEmpty()) {
            sb.append("placements:");
            sb.append(this.placements + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PlacementsNested<N>
    extends PlacementFluent<PlacementsNested<N>>
    implements Nested<N> {
        PlacementBuilder builder;
        int index;

        PlacementsNested(int index, Placement item) {
            this.index = index;
            this.builder = new PlacementBuilder(this, item);
        }

        public N and() {
            return (N)PlaceableFluent.this.setToPlacements(this.index, this.builder.build());
        }

        public N endPlacement() {
            return this.and();
        }
    }
}

