/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.sources.v1;

import io.fabric8.knative.sources.v1.ApiServerSource;
import io.fabric8.knative.sources.v1.ApiServerSourceBuilder;
import io.fabric8.knative.sources.v1.ApiServerSourceFluentImpl;
import io.fabric8.knative.sources.v1.ApiServerSourceList;
import io.fabric8.knative.sources.v1.ApiServerSourceListFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ApiServerSourceListFluentImpl<A extends ApiServerSourceListFluent<A>>
extends BaseFluent<A>
implements ApiServerSourceListFluent<A> {
    private String apiVersion;
    private ArrayList<ApiServerSourceBuilder> items = new ArrayList();
    private String kind;
    private ListMeta metadata;

    public ApiServerSourceListFluentImpl() {
    }

    public ApiServerSourceListFluentImpl(ApiServerSourceList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A addToItems(Integer index, ApiServerSource item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        ApiServerSourceBuilder builder = new ApiServerSourceBuilder(item);
        this._visitables.get((Object)"items").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"items").size(), builder);
        this.items.add(index >= 0 ? index.intValue() : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(Integer index, ApiServerSource item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        ApiServerSourceBuilder builder = new ApiServerSourceBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"items").size()) {
            this._visitables.get((Object)"items").add(builder);
        } else {
            this._visitables.get((Object)"items").set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(ApiServerSource ... items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (ApiServerSource item : items) {
            ApiServerSourceBuilder builder = new ApiServerSourceBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<ApiServerSource> items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (ApiServerSource item : items) {
            ApiServerSourceBuilder builder = new ApiServerSourceBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(ApiServerSource ... items) {
        for (ApiServerSource item : items) {
            ApiServerSourceBuilder builder = new ApiServerSourceBuilder(item);
            this._visitables.get((Object)"items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<ApiServerSource> items) {
        for (ApiServerSource item : items) {
            ApiServerSourceBuilder builder = new ApiServerSourceBuilder(item);
            this._visitables.get((Object)"items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromItems(Predicate<ApiServerSourceBuilder> predicate) {
        if (this.items == null) {
            return (A)this;
        }
        Iterator<ApiServerSourceBuilder> each = this.items.iterator();
        List visitables = this._visitables.get((Object)"items");
        while (each.hasNext()) {
            ApiServerSourceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ApiServerSource> getItems() {
        return this.items != null ? ApiServerSourceListFluentImpl.build(this.items) : null;
    }

    @Override
    public List<ApiServerSource> buildItems() {
        return this.items != null ? ApiServerSourceListFluentImpl.build(this.items) : null;
    }

    @Override
    public ApiServerSource buildItem(Integer index) {
        return this.items.get(index).build();
    }

    @Override
    public ApiServerSource buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public ApiServerSource buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public ApiServerSource buildMatchingItem(Predicate<ApiServerSourceBuilder> predicate) {
        for (ApiServerSourceBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingItem(Predicate<ApiServerSourceBuilder> predicate) {
        for (ApiServerSourceBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withItems(List<ApiServerSource> items) {
        if (this.items != null) {
            this._visitables.get((Object)"items").removeAll(this.items);
        }
        if (items != null) {
            this.items = new ArrayList();
            for (ApiServerSource item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    @Override
    public A withItems(ApiServerSource ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (ApiServerSource item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public ApiServerSourceListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public ApiServerSourceListFluent.ItemsNested<A> addNewItemLike(ApiServerSource item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public ApiServerSourceListFluent.ItemsNested<A> setNewItemLike(Integer index, ApiServerSource item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public ApiServerSourceListFluent.ItemsNested<A> editItem(Integer index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public ApiServerSourceListFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public ApiServerSourceListFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public ApiServerSourceListFluent.ItemsNested<A> editMatchingItem(Predicate<ApiServerSourceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.test(this.items.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        this.metadata = metadata;
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public A withNewMetadata(String _continue, Long remainingItemCount, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiServerSourceListFluentImpl that = (ApiServerSourceListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals((Object)that.metadata) : that.metadata != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.items, this.kind, this.metadata, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.items != null && !this.items.isEmpty()) {
            sb.append("items:");
            sb.append(this.items + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata);
        }
        sb.append("}");
        return sb.toString();
    }

    class ItemsNestedImpl<N>
    extends ApiServerSourceFluentImpl<ApiServerSourceListFluent.ItemsNested<N>>
    implements ApiServerSourceListFluent.ItemsNested<N>,
    Nested<N> {
        ApiServerSourceBuilder builder;
        Integer index;

        ItemsNestedImpl(Integer index, ApiServerSource item) {
            this.index = index;
            this.builder = new ApiServerSourceBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new ApiServerSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ApiServerSourceListFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

