/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaNetSpec;
import io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaNetSpecBuilder;
import io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaNetSpecFluentImpl;
import io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpec;
import io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceSpecFluent;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverrides;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverridesBuilder;
import io.fabric8.knative.internal.pkg.apis.duck.v1.CloudEventOverridesFluentImpl;
import io.fabric8.knative.internal.pkg.apis.duck.v1.Destination;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class KafkaSourceSpecFluentImpl<A extends KafkaSourceSpecFluent<A>>
extends BaseFluent<A>
implements KafkaSourceSpecFluent<A> {
    private List<String> bootstrapServers;
    private CloudEventOverridesBuilder ceOverrides;
    private String consumerGroup;
    private KafkaNetSpecBuilder net;
    private DestinationBuilder sink;
    private List<String> topics;

    public KafkaSourceSpecFluentImpl() {
    }

    public KafkaSourceSpecFluentImpl(KafkaSourceSpec instance) {
        this.withBootstrapServers(instance.getBootstrapServers());
        this.withCeOverrides(instance.getCeOverrides());
        this.withConsumerGroup(instance.getConsumerGroup());
        this.withNet(instance.getNet());
        this.withSink(instance.getSink());
        this.withTopics(instance.getTopics());
    }

    @Override
    public A addToBootstrapServers(int index, String item) {
        if (this.bootstrapServers == null) {
            this.bootstrapServers = new ArrayList<String>();
        }
        this.bootstrapServers.add(index, item);
        return (A)this;
    }

    @Override
    public A setToBootstrapServers(int index, String item) {
        if (this.bootstrapServers == null) {
            this.bootstrapServers = new ArrayList<String>();
        }
        this.bootstrapServers.set(index, item);
        return (A)this;
    }

    @Override
    public A addToBootstrapServers(String ... items) {
        if (this.bootstrapServers == null) {
            this.bootstrapServers = new ArrayList<String>();
        }
        for (String item : items) {
            this.bootstrapServers.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToBootstrapServers(Collection<String> items) {
        if (this.bootstrapServers == null) {
            this.bootstrapServers = new ArrayList<String>();
        }
        for (String item : items) {
            this.bootstrapServers.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromBootstrapServers(String ... items) {
        for (String item : items) {
            if (this.bootstrapServers == null) continue;
            this.bootstrapServers.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromBootstrapServers(Collection<String> items) {
        for (String item : items) {
            if (this.bootstrapServers == null) continue;
            this.bootstrapServers.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getBootstrapServers() {
        return this.bootstrapServers;
    }

    @Override
    public String getBootstrapServer(int index) {
        return this.bootstrapServers.get(index);
    }

    @Override
    public String getFirstBootstrapServer() {
        return this.bootstrapServers.get(0);
    }

    @Override
    public String getLastBootstrapServer() {
        return this.bootstrapServers.get(this.bootstrapServers.size() - 1);
    }

    @Override
    public String getMatchingBootstrapServer(Predicate<String> predicate) {
        for (String item : this.bootstrapServers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingBootstrapServer(Predicate<String> predicate) {
        for (String item : this.bootstrapServers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withBootstrapServers(List<String> bootstrapServers) {
        if (this.bootstrapServers != null) {
            this._visitables.get((Object)"bootstrapServers").removeAll(this.bootstrapServers);
        }
        if (bootstrapServers != null) {
            this.bootstrapServers = new ArrayList<String>();
            for (String item : bootstrapServers) {
                this.addToBootstrapServers(item);
            }
        } else {
            this.bootstrapServers = null;
        }
        return (A)this;
    }

    @Override
    public A withBootstrapServers(String ... bootstrapServers) {
        if (this.bootstrapServers != null) {
            this.bootstrapServers.clear();
        }
        if (bootstrapServers != null) {
            for (String item : bootstrapServers) {
                this.addToBootstrapServers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasBootstrapServers() {
        return this.bootstrapServers != null && !this.bootstrapServers.isEmpty();
    }

    @Override
    public A addNewBootstrapServer(String arg1) {
        return this.addToBootstrapServers(new String(arg1));
    }

    @Override
    public A addNewBootstrapServer(StringBuilder arg1) {
        return this.addToBootstrapServers(new String(arg1));
    }

    @Override
    public A addNewBootstrapServer(StringBuffer arg1) {
        return this.addToBootstrapServers(new String(arg1));
    }

    @Override
    @Deprecated
    public CloudEventOverrides getCeOverrides() {
        return this.ceOverrides != null ? this.ceOverrides.build() : null;
    }

    @Override
    public CloudEventOverrides buildCeOverrides() {
        return this.ceOverrides != null ? this.ceOverrides.build() : null;
    }

    @Override
    public A withCeOverrides(CloudEventOverrides ceOverrides) {
        this._visitables.get((Object)"ceOverrides").remove(this.ceOverrides);
        if (ceOverrides != null) {
            this.ceOverrides = new CloudEventOverridesBuilder(ceOverrides);
            this._visitables.get((Object)"ceOverrides").add(this.ceOverrides);
        }
        return (A)this;
    }

    @Override
    public Boolean hasCeOverrides() {
        return this.ceOverrides != null;
    }

    @Override
    public KafkaSourceSpecFluent.CeOverridesNested<A> withNewCeOverrides() {
        return new CeOverridesNestedImpl();
    }

    @Override
    public KafkaSourceSpecFluent.CeOverridesNested<A> withNewCeOverridesLike(CloudEventOverrides item) {
        return new CeOverridesNestedImpl(item);
    }

    @Override
    public KafkaSourceSpecFluent.CeOverridesNested<A> editCeOverrides() {
        return this.withNewCeOverridesLike(this.getCeOverrides());
    }

    @Override
    public KafkaSourceSpecFluent.CeOverridesNested<A> editOrNewCeOverrides() {
        return this.withNewCeOverridesLike(this.getCeOverrides() != null ? this.getCeOverrides() : new CloudEventOverridesBuilder().build());
    }

    @Override
    public KafkaSourceSpecFluent.CeOverridesNested<A> editOrNewCeOverridesLike(CloudEventOverrides item) {
        return this.withNewCeOverridesLike(this.getCeOverrides() != null ? this.getCeOverrides() : item);
    }

    @Override
    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    @Override
    public A withConsumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
        return (A)this;
    }

    @Override
    public Boolean hasConsumerGroup() {
        return this.consumerGroup != null;
    }

    @Override
    public A withNewConsumerGroup(String arg1) {
        return this.withConsumerGroup(new String(arg1));
    }

    @Override
    public A withNewConsumerGroup(StringBuilder arg1) {
        return this.withConsumerGroup(new String(arg1));
    }

    @Override
    public A withNewConsumerGroup(StringBuffer arg1) {
        return this.withConsumerGroup(new String(arg1));
    }

    @Override
    @Deprecated
    public KafkaNetSpec getNet() {
        return this.net != null ? this.net.build() : null;
    }

    @Override
    public KafkaNetSpec buildNet() {
        return this.net != null ? this.net.build() : null;
    }

    @Override
    public A withNet(KafkaNetSpec net) {
        this._visitables.get((Object)"net").remove(this.net);
        if (net != null) {
            this.net = new KafkaNetSpecBuilder(net);
            this._visitables.get((Object)"net").add(this.net);
        }
        return (A)this;
    }

    @Override
    public Boolean hasNet() {
        return this.net != null;
    }

    @Override
    public KafkaSourceSpecFluent.NetNested<A> withNewNet() {
        return new NetNestedImpl();
    }

    @Override
    public KafkaSourceSpecFluent.NetNested<A> withNewNetLike(KafkaNetSpec item) {
        return new NetNestedImpl(item);
    }

    @Override
    public KafkaSourceSpecFluent.NetNested<A> editNet() {
        return this.withNewNetLike(this.getNet());
    }

    @Override
    public KafkaSourceSpecFluent.NetNested<A> editOrNewNet() {
        return this.withNewNetLike(this.getNet() != null ? this.getNet() : new KafkaNetSpecBuilder().build());
    }

    @Override
    public KafkaSourceSpecFluent.NetNested<A> editOrNewNetLike(KafkaNetSpec item) {
        return this.withNewNetLike(this.getNet() != null ? this.getNet() : item);
    }

    @Override
    @Deprecated
    public Destination getSink() {
        return this.sink != null ? this.sink.build() : null;
    }

    @Override
    public Destination buildSink() {
        return this.sink != null ? this.sink.build() : null;
    }

    @Override
    public A withSink(Destination sink) {
        this._visitables.get((Object)"sink").remove(this.sink);
        if (sink != null) {
            this.sink = new DestinationBuilder(sink);
            this._visitables.get((Object)"sink").add(this.sink);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSink() {
        return this.sink != null;
    }

    @Override
    public KafkaSourceSpecFluent.SinkNested<A> withNewSink() {
        return new SinkNestedImpl();
    }

    @Override
    public KafkaSourceSpecFluent.SinkNested<A> withNewSinkLike(Destination item) {
        return new SinkNestedImpl(item);
    }

    @Override
    public KafkaSourceSpecFluent.SinkNested<A> editSink() {
        return this.withNewSinkLike(this.getSink());
    }

    @Override
    public KafkaSourceSpecFluent.SinkNested<A> editOrNewSink() {
        return this.withNewSinkLike(this.getSink() != null ? this.getSink() : new DestinationBuilder().build());
    }

    @Override
    public KafkaSourceSpecFluent.SinkNested<A> editOrNewSinkLike(Destination item) {
        return this.withNewSinkLike(this.getSink() != null ? this.getSink() : item);
    }

    @Override
    public A addToTopics(int index, String item) {
        if (this.topics == null) {
            this.topics = new ArrayList<String>();
        }
        this.topics.add(index, item);
        return (A)this;
    }

    @Override
    public A setToTopics(int index, String item) {
        if (this.topics == null) {
            this.topics = new ArrayList<String>();
        }
        this.topics.set(index, item);
        return (A)this;
    }

    @Override
    public A addToTopics(String ... items) {
        if (this.topics == null) {
            this.topics = new ArrayList<String>();
        }
        for (String item : items) {
            this.topics.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToTopics(Collection<String> items) {
        if (this.topics == null) {
            this.topics = new ArrayList<String>();
        }
        for (String item : items) {
            this.topics.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromTopics(String ... items) {
        for (String item : items) {
            if (this.topics == null) continue;
            this.topics.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTopics(Collection<String> items) {
        for (String item : items) {
            if (this.topics == null) continue;
            this.topics.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getTopics() {
        return this.topics;
    }

    @Override
    public String getTopic(int index) {
        return this.topics.get(index);
    }

    @Override
    public String getFirstTopic() {
        return this.topics.get(0);
    }

    @Override
    public String getLastTopic() {
        return this.topics.get(this.topics.size() - 1);
    }

    @Override
    public String getMatchingTopic(Predicate<String> predicate) {
        for (String item : this.topics) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingTopic(Predicate<String> predicate) {
        for (String item : this.topics) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTopics(List<String> topics) {
        if (this.topics != null) {
            this._visitables.get((Object)"topics").removeAll(this.topics);
        }
        if (topics != null) {
            this.topics = new ArrayList<String>();
            for (String item : topics) {
                this.addToTopics(item);
            }
        } else {
            this.topics = null;
        }
        return (A)this;
    }

    @Override
    public A withTopics(String ... topics) {
        if (this.topics != null) {
            this.topics.clear();
        }
        if (topics != null) {
            for (String item : topics) {
                this.addToTopics(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTopics() {
        return this.topics != null && !this.topics.isEmpty();
    }

    @Override
    public A addNewTopic(String arg1) {
        return this.addToTopics(new String(arg1));
    }

    @Override
    public A addNewTopic(StringBuilder arg1) {
        return this.addToTopics(new String(arg1));
    }

    @Override
    public A addNewTopic(StringBuffer arg1) {
        return this.addToTopics(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaSourceSpecFluentImpl that = (KafkaSourceSpecFluentImpl)o;
        if (this.bootstrapServers != null ? !this.bootstrapServers.equals(that.bootstrapServers) : that.bootstrapServers != null) {
            return false;
        }
        if (this.ceOverrides != null ? !this.ceOverrides.equals(that.ceOverrides) : that.ceOverrides != null) {
            return false;
        }
        if (this.consumerGroup != null ? !this.consumerGroup.equals(that.consumerGroup) : that.consumerGroup != null) {
            return false;
        }
        if (this.net != null ? !this.net.equals(that.net) : that.net != null) {
            return false;
        }
        if (this.sink != null ? !this.sink.equals(that.sink) : that.sink != null) {
            return false;
        }
        return !(this.topics != null ? !this.topics.equals(that.topics) : that.topics != null);
    }

    public int hashCode() {
        return Objects.hash(this.bootstrapServers, this.ceOverrides, this.consumerGroup, this.net, this.sink, this.topics, super.hashCode());
    }

    public class SinkNestedImpl<N>
    extends DestinationFluentImpl<KafkaSourceSpecFluent.SinkNested<N>>
    implements KafkaSourceSpecFluent.SinkNested<N>,
    Nested<N> {
        private final DestinationBuilder builder;

        SinkNestedImpl(Destination item) {
            this.builder = new DestinationBuilder(this, item);
        }

        SinkNestedImpl() {
            this.builder = new DestinationBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaSourceSpecFluentImpl.this.withSink(this.builder.build());
        }

        @Override
        public N endSink() {
            return this.and();
        }
    }

    public class NetNestedImpl<N>
    extends KafkaNetSpecFluentImpl<KafkaSourceSpecFluent.NetNested<N>>
    implements KafkaSourceSpecFluent.NetNested<N>,
    Nested<N> {
        private final KafkaNetSpecBuilder builder;

        NetNestedImpl(KafkaNetSpec item) {
            this.builder = new KafkaNetSpecBuilder(this, item);
        }

        NetNestedImpl() {
            this.builder = new KafkaNetSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaSourceSpecFluentImpl.this.withNet(this.builder.build());
        }

        @Override
        public N endNet() {
            return this.and();
        }
    }

    public class CeOverridesNestedImpl<N>
    extends CloudEventOverridesFluentImpl<KafkaSourceSpecFluent.CeOverridesNested<N>>
    implements KafkaSourceSpecFluent.CeOverridesNested<N>,
    Nested<N> {
        private final CloudEventOverridesBuilder builder;

        CeOverridesNestedImpl(CloudEventOverrides item) {
            this.builder = new CloudEventOverridesBuilder(this, item);
        }

        CeOverridesNestedImpl() {
            this.builder = new CloudEventOverridesBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaSourceSpecFluentImpl.this.withCeOverrides(this.builder.build());
        }

        @Override
        public N endCeOverrides() {
            return this.and();
        }
    }
}

