/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.flows.v1alpha1;

import io.fabric8.knative.dev.messaging.v1beta1.ChannelTemplateSpec;
import io.fabric8.knative.dev.messaging.v1beta1.ChannelTemplateSpecBuilder;
import io.fabric8.knative.dev.messaging.v1beta1.ChannelTemplateSpecFluentImpl;
import io.fabric8.knative.duck.v1.Destination;
import io.fabric8.knative.duck.v1.DestinationBuilder;
import io.fabric8.knative.duck.v1.DestinationFluentImpl;
import io.fabric8.knative.flows.v1alpha1.ParallelBranch;
import io.fabric8.knative.flows.v1alpha1.ParallelBranchBuilder;
import io.fabric8.knative.flows.v1alpha1.ParallelBranchFluentImpl;
import io.fabric8.knative.flows.v1alpha1.ParallelSpec;
import io.fabric8.knative.flows.v1alpha1.ParallelSpecFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ParallelSpecFluentImpl<A extends ParallelSpecFluent<A>>
extends BaseFluent<A>
implements ParallelSpecFluent<A> {
    private List<ParallelBranchBuilder> branches;
    private ChannelTemplateSpecBuilder channelTemplate;
    private DestinationBuilder reply;

    public ParallelSpecFluentImpl() {
    }

    public ParallelSpecFluentImpl(ParallelSpec instance) {
        this.withBranches(instance.getBranches());
        this.withChannelTemplate(instance.getChannelTemplate());
        this.withReply(instance.getReply());
    }

    @Override
    public A addToBranches(int index, ParallelBranch item) {
        if (this.branches == null) {
            this.branches = new ArrayList<ParallelBranchBuilder>();
        }
        ParallelBranchBuilder builder = new ParallelBranchBuilder(item);
        this._visitables.get((Object)"branches").add(index >= 0 ? index : this._visitables.get((Object)"branches").size(), builder);
        this.branches.add(index >= 0 ? index : this.branches.size(), builder);
        return (A)this;
    }

    @Override
    public A setToBranches(int index, ParallelBranch item) {
        if (this.branches == null) {
            this.branches = new ArrayList<ParallelBranchBuilder>();
        }
        ParallelBranchBuilder builder = new ParallelBranchBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"branches").size()) {
            this._visitables.get((Object)"branches").add(builder);
        } else {
            this._visitables.get((Object)"branches").set(index, builder);
        }
        if (index < 0 || index >= this.branches.size()) {
            this.branches.add(builder);
        } else {
            this.branches.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToBranches(ParallelBranch ... items) {
        if (this.branches == null) {
            this.branches = new ArrayList<ParallelBranchBuilder>();
        }
        for (ParallelBranch item : items) {
            ParallelBranchBuilder builder = new ParallelBranchBuilder(item);
            this._visitables.get((Object)"branches").add(builder);
            this.branches.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToBranches(Collection<ParallelBranch> items) {
        if (this.branches == null) {
            this.branches = new ArrayList<ParallelBranchBuilder>();
        }
        for (ParallelBranch item : items) {
            ParallelBranchBuilder builder = new ParallelBranchBuilder(item);
            this._visitables.get((Object)"branches").add(builder);
            this.branches.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromBranches(ParallelBranch ... items) {
        for (ParallelBranch item : items) {
            ParallelBranchBuilder builder = new ParallelBranchBuilder(item);
            this._visitables.get((Object)"branches").remove(builder);
            if (this.branches == null) continue;
            this.branches.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromBranches(Collection<ParallelBranch> items) {
        for (ParallelBranch item : items) {
            ParallelBranchBuilder builder = new ParallelBranchBuilder(item);
            this._visitables.get((Object)"branches").remove(builder);
            if (this.branches == null) continue;
            this.branches.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromBranches(Predicate<ParallelBranchBuilder> predicate) {
        if (this.branches == null) {
            return (A)this;
        }
        Iterator<ParallelBranchBuilder> each = this.branches.iterator();
        List visitables = this._visitables.get((Object)"branches");
        while (each.hasNext()) {
            ParallelBranchBuilder builder = each.next();
            if (!predicate.apply((Object)builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ParallelBranch> getBranches() {
        return ParallelSpecFluentImpl.build(this.branches);
    }

    @Override
    public List<ParallelBranch> buildBranches() {
        return ParallelSpecFluentImpl.build(this.branches);
    }

    @Override
    public ParallelBranch buildBranch(int index) {
        return this.branches.get(index).build();
    }

    @Override
    public ParallelBranch buildFirstBranch() {
        return this.branches.get(0).build();
    }

    @Override
    public ParallelBranch buildLastBranch() {
        return this.branches.get(this.branches.size() - 1).build();
    }

    @Override
    public ParallelBranch buildMatchingBranch(Predicate<ParallelBranchBuilder> predicate) {
        for (ParallelBranchBuilder item : this.branches) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingBranch(Predicate<ParallelBranchBuilder> predicate) {
        for (ParallelBranchBuilder item : this.branches) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withBranches(List<ParallelBranch> branches) {
        if (this.branches != null) {
            this._visitables.get((Object)"branches").removeAll(this.branches);
        }
        if (branches != null) {
            this.branches = new ArrayList<ParallelBranchBuilder>();
            for (ParallelBranch item : branches) {
                this.addToBranches(item);
            }
        } else {
            this.branches = null;
        }
        return (A)this;
    }

    @Override
    public A withBranches(ParallelBranch ... branches) {
        if (this.branches != null) {
            this.branches.clear();
        }
        if (branches != null) {
            for (ParallelBranch item : branches) {
                this.addToBranches(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasBranches() {
        return this.branches != null && !this.branches.isEmpty();
    }

    @Override
    public ParallelSpecFluent.BranchesNested<A> addNewBranch() {
        return new BranchesNestedImpl();
    }

    @Override
    public ParallelSpecFluent.BranchesNested<A> addNewBranchLike(ParallelBranch item) {
        return new BranchesNestedImpl(-1, item);
    }

    @Override
    public ParallelSpecFluent.BranchesNested<A> setNewBranchLike(int index, ParallelBranch item) {
        return new BranchesNestedImpl(index, item);
    }

    @Override
    public ParallelSpecFluent.BranchesNested<A> editBranch(int index) {
        if (this.branches.size() <= index) {
            throw new RuntimeException("Can't edit branches. Index exceeds size.");
        }
        return this.setNewBranchLike(index, this.buildBranch(index));
    }

    @Override
    public ParallelSpecFluent.BranchesNested<A> editFirstBranch() {
        if (this.branches.size() == 0) {
            throw new RuntimeException("Can't edit first branches. The list is empty.");
        }
        return this.setNewBranchLike(0, this.buildBranch(0));
    }

    @Override
    public ParallelSpecFluent.BranchesNested<A> editLastBranch() {
        int index = this.branches.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last branches. The list is empty.");
        }
        return this.setNewBranchLike(index, this.buildBranch(index));
    }

    @Override
    public ParallelSpecFluent.BranchesNested<A> editMatchingBranch(Predicate<ParallelBranchBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.branches.size(); ++i) {
            if (!predicate.apply((Object)this.branches.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching branches. No match found.");
        }
        return this.setNewBranchLike(index, this.buildBranch(index));
    }

    @Override
    @Deprecated
    public ChannelTemplateSpec getChannelTemplate() {
        return this.channelTemplate != null ? this.channelTemplate.build() : null;
    }

    @Override
    public ChannelTemplateSpec buildChannelTemplate() {
        return this.channelTemplate != null ? this.channelTemplate.build() : null;
    }

    @Override
    public A withChannelTemplate(ChannelTemplateSpec channelTemplate) {
        this._visitables.get((Object)"channelTemplate").remove(this.channelTemplate);
        if (channelTemplate != null) {
            this.channelTemplate = new ChannelTemplateSpecBuilder(channelTemplate);
            this._visitables.get((Object)"channelTemplate").add(this.channelTemplate);
        }
        return (A)this;
    }

    @Override
    public Boolean hasChannelTemplate() {
        return this.channelTemplate != null;
    }

    @Override
    public ParallelSpecFluent.ChannelTemplateNested<A> withNewChannelTemplate() {
        return new ChannelTemplateNestedImpl();
    }

    @Override
    public ParallelSpecFluent.ChannelTemplateNested<A> withNewChannelTemplateLike(ChannelTemplateSpec item) {
        return new ChannelTemplateNestedImpl(item);
    }

    @Override
    public ParallelSpecFluent.ChannelTemplateNested<A> editChannelTemplate() {
        return this.withNewChannelTemplateLike(this.getChannelTemplate());
    }

    @Override
    public ParallelSpecFluent.ChannelTemplateNested<A> editOrNewChannelTemplate() {
        return this.withNewChannelTemplateLike(this.getChannelTemplate() != null ? this.getChannelTemplate() : new ChannelTemplateSpecBuilder().build());
    }

    @Override
    public ParallelSpecFluent.ChannelTemplateNested<A> editOrNewChannelTemplateLike(ChannelTemplateSpec item) {
        return this.withNewChannelTemplateLike(this.getChannelTemplate() != null ? this.getChannelTemplate() : item);
    }

    @Override
    @Deprecated
    public Destination getReply() {
        return this.reply != null ? this.reply.build() : null;
    }

    @Override
    public Destination buildReply() {
        return this.reply != null ? this.reply.build() : null;
    }

    @Override
    public A withReply(Destination reply) {
        this._visitables.get((Object)"reply").remove(this.reply);
        if (reply != null) {
            this.reply = new DestinationBuilder(reply);
            this._visitables.get((Object)"reply").add(this.reply);
        }
        return (A)this;
    }

    @Override
    public Boolean hasReply() {
        return this.reply != null;
    }

    @Override
    public ParallelSpecFluent.ReplyNested<A> withNewReply() {
        return new ReplyNestedImpl();
    }

    @Override
    public ParallelSpecFluent.ReplyNested<A> withNewReplyLike(Destination item) {
        return new ReplyNestedImpl(item);
    }

    @Override
    public ParallelSpecFluent.ReplyNested<A> editReply() {
        return this.withNewReplyLike(this.getReply());
    }

    @Override
    public ParallelSpecFluent.ReplyNested<A> editOrNewReply() {
        return this.withNewReplyLike(this.getReply() != null ? this.getReply() : new DestinationBuilder().build());
    }

    @Override
    public ParallelSpecFluent.ReplyNested<A> editOrNewReplyLike(Destination item) {
        return this.withNewReplyLike(this.getReply() != null ? this.getReply() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParallelSpecFluentImpl that = (ParallelSpecFluentImpl)o;
        if (this.branches != null ? !this.branches.equals(that.branches) : that.branches != null) {
            return false;
        }
        if (this.channelTemplate != null ? !this.channelTemplate.equals(that.channelTemplate) : that.channelTemplate != null) {
            return false;
        }
        return !(this.reply != null ? !this.reply.equals(that.reply) : that.reply != null);
    }

    public class ReplyNestedImpl<N>
    extends DestinationFluentImpl<ParallelSpecFluent.ReplyNested<N>>
    implements ParallelSpecFluent.ReplyNested<N>,
    Nested<N> {
        private final DestinationBuilder builder;

        ReplyNestedImpl(Destination item) {
            this.builder = new DestinationBuilder(this, item);
        }

        ReplyNestedImpl() {
            this.builder = new DestinationBuilder(this);
        }

        @Override
        public N and() {
            return (N)ParallelSpecFluentImpl.this.withReply(this.builder.build());
        }

        @Override
        public N endReply() {
            return this.and();
        }
    }

    public class ChannelTemplateNestedImpl<N>
    extends ChannelTemplateSpecFluentImpl<ParallelSpecFluent.ChannelTemplateNested<N>>
    implements ParallelSpecFluent.ChannelTemplateNested<N>,
    Nested<N> {
        private final ChannelTemplateSpecBuilder builder;

        ChannelTemplateNestedImpl(ChannelTemplateSpec item) {
            this.builder = new ChannelTemplateSpecBuilder(this, item);
        }

        ChannelTemplateNestedImpl() {
            this.builder = new ChannelTemplateSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)ParallelSpecFluentImpl.this.withChannelTemplate(this.builder.build());
        }

        @Override
        public N endChannelTemplate() {
            return this.and();
        }
    }

    public class BranchesNestedImpl<N>
    extends ParallelBranchFluentImpl<ParallelSpecFluent.BranchesNested<N>>
    implements ParallelSpecFluent.BranchesNested<N>,
    Nested<N> {
        private final ParallelBranchBuilder builder;
        private final int index;

        BranchesNestedImpl(int index, ParallelBranch item) {
            this.index = index;
            this.builder = new ParallelBranchBuilder(this, item);
        }

        BranchesNestedImpl() {
            this.index = -1;
            this.builder = new ParallelBranchBuilder(this);
        }

        @Override
        public N and() {
            return (N)ParallelSpecFluentImpl.this.setToBranches(this.index, this.builder.build());
        }

        @Override
        public N endBranch() {
            return this.and();
        }
    }
}

